/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor.comments;

import java.io.IOException;
import org.watermedia.shaded.schabi.newpipe.extractor.ListExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.ListInfo;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsExtractor;
import org.watermedia.shaded.schabi.newpipe.extractor.comments.CommentsInfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.utils.ExtractorHelper;

public final class CommentsInfo
extends ListInfo<CommentsInfoItem> {
    private transient CommentsExtractor commentsExtractor;
    private boolean commentsDisabled = false;
    private int commentsCount;

    private CommentsInfo(int serviceId, ListLinkHandler listUrlIdHandler, String name) {
        super(serviceId, listUrlIdHandler, name);
    }

    public static CommentsInfo getInfo(String url) throws IOException, ExtractionException {
        return CommentsInfo.getInfo(NewPipe.getServiceByUrl(url), url);
    }

    public static CommentsInfo getInfo(StreamingService service, String url) throws ExtractionException, IOException {
        return CommentsInfo.getInfo(service.getCommentsExtractor(url));
    }

    public static CommentsInfo getInfo(CommentsExtractor commentsExtractor) throws IOException, ExtractionException {
        if (commentsExtractor == null) {
            return null;
        }
        commentsExtractor.fetchPage();
        String name = commentsExtractor.getName();
        int serviceId = commentsExtractor.getServiceId();
        ListLinkHandler listUrlIdHandler = commentsExtractor.getLinkHandler();
        CommentsInfo commentsInfo = new CommentsInfo(serviceId, listUrlIdHandler, name);
        commentsInfo.setCommentsExtractor(commentsExtractor);
        ListExtractor.InfoItemsPage<CommentsInfoItem> initialCommentsPage = ExtractorHelper.getItemsPageOrLogError(commentsInfo, commentsExtractor);
        commentsInfo.setCommentsDisabled(commentsExtractor.isCommentsDisabled());
        commentsInfo.setRelatedItems(initialCommentsPage.getItems());
        try {
            commentsInfo.setCommentsCount(commentsExtractor.getCommentsCount());
        }
        catch (Exception e) {
            commentsInfo.addError(e);
        }
        commentsInfo.setNextPage(initialCommentsPage.getNextPage());
        return commentsInfo;
    }

    public static ListExtractor.InfoItemsPage<CommentsInfoItem> getMoreItems(CommentsInfo commentsInfo, Page page) throws ExtractionException, IOException {
        return CommentsInfo.getMoreItems(NewPipe.getService(commentsInfo.getServiceId()), commentsInfo.getUrl(), page);
    }

    public static ListExtractor.InfoItemsPage<CommentsInfoItem> getMoreItems(StreamingService service, CommentsInfo commentsInfo, Page page) throws IOException, ExtractionException {
        return CommentsInfo.getMoreItems(service, commentsInfo.getUrl(), page);
    }

    public static ListExtractor.InfoItemsPage<CommentsInfoItem> getMoreItems(StreamingService service, String url, Page page) throws IOException, ExtractionException {
        return service.getCommentsExtractor(url).getPage(page);
    }

    public CommentsExtractor getCommentsExtractor() {
        return this.commentsExtractor;
    }

    public void setCommentsExtractor(CommentsExtractor commentsExtractor) {
        this.commentsExtractor = commentsExtractor;
    }

    public boolean isCommentsDisabled() {
        return this.commentsDisabled;
    }

    public void setCommentsDisabled(boolean commentsDisabled) {
        this.commentsDisabled = commentsDisabled;
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public void setCommentsCount(int commentsCount) {
        this.commentsCount = commentsCount;
    }
}

