/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.util.List;
import org.watermedia.shaded.schabi.newpipe.extractor.Info;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;

public abstract class ListInfo<T extends InfoItem>
extends Info {
    private List<T> relatedItems;
    private Page nextPage = null;
    private final List<String> contentFilters;
    private final String sortFilter;

    public ListInfo(int serviceId, String id2, String url, String originalUrl, String name, List<String> contentFilter, String sortFilter) {
        super(serviceId, id2, url, originalUrl, name);
        this.contentFilters = contentFilter;
        this.sortFilter = sortFilter;
    }

    public ListInfo(int serviceId, ListLinkHandler listUrlIdHandler, String name) {
        super(serviceId, listUrlIdHandler, name);
        this.contentFilters = listUrlIdHandler.getContentFilters();
        this.sortFilter = listUrlIdHandler.getSortFilter();
    }

    public List<T> getRelatedItems() {
        return this.relatedItems;
    }

    public void setRelatedItems(List<T> relatedItems) {
        this.relatedItems = relatedItems;
    }

    public boolean hasNextPage() {
        return Page.isValid(this.nextPage);
    }

    public Page getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(Page page) {
        this.nextPage = page;
    }

    public List<String> getContentFilters() {
        return this.contentFilters;
    }

    public String getSortFilter() {
        return this.sortFilter;
    }
}

