/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.Extractor;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItem;
import org.watermedia.shaded.schabi.newpipe.extractor.InfoItemsCollector;
import org.watermedia.shaded.schabi.newpipe.extractor.Page;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.ListLinkHandler;

public abstract class ListExtractor<R extends InfoItem>
extends Extractor {
    public static final long ITEM_COUNT_UNKNOWN = -1L;
    public static final long ITEM_COUNT_INFINITE = -2L;
    public static final long ITEM_COUNT_MORE_THAN_100 = -3L;

    public ListExtractor(StreamingService service, ListLinkHandler linkHandler) {
        super(service, linkHandler);
    }

    @Nonnull
    public abstract InfoItemsPage<R> getInitialPage() throws IOException, ExtractionException;

    public abstract InfoItemsPage<R> getPage(Page var1) throws IOException, ExtractionException;

    @Override
    @Nonnull
    public ListLinkHandler getLinkHandler() {
        return (ListLinkHandler)super.getLinkHandler();
    }

    public static class InfoItemsPage<T extends InfoItem> {
        private static final InfoItemsPage<InfoItem> EMPTY = new InfoItemsPage(Collections.emptyList(), null, Collections.emptyList());
        private final List<T> itemsList;
        @Nullable
        private final Page nextPage;
        private final List<Throwable> errors;

        public static <T extends InfoItem> InfoItemsPage<T> emptyPage() {
            return EMPTY;
        }

        public InfoItemsPage(InfoItemsCollector<T, ?> collector, @Nullable Page nextPage) {
            this(collector.getItems(), nextPage, collector.getErrors());
        }

        public InfoItemsPage(List<T> itemsList, @Nullable Page nextPage, List<Throwable> errors) {
            this.itemsList = itemsList;
            this.nextPage = nextPage;
            this.errors = errors;
        }

        public boolean hasNextPage() {
            return Page.isValid(this.nextPage);
        }

        public List<T> getItems() {
            return this.itemsList;
        }

        @Nullable
        public Page getNextPage() {
            return this.nextPage;
        }

        public List<Throwable> getErrors() {
            return this.errors;
        }
    }
}

