/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.schabi.newpipe.extractor;

import java.io.IOException;
import java.util.Objects;
import org.watermedia.shaded.javax.annotation.Nonnull;
import org.watermedia.shaded.javax.annotation.Nullable;
import org.watermedia.shaded.schabi.newpipe.extractor.NewPipe;
import org.watermedia.shaded.schabi.newpipe.extractor.StreamingService;
import org.watermedia.shaded.schabi.newpipe.extractor.downloader.Downloader;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ExtractionException;
import org.watermedia.shaded.schabi.newpipe.extractor.exceptions.ParsingException;
import org.watermedia.shaded.schabi.newpipe.extractor.linkhandler.LinkHandler;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.ContentCountry;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.Localization;
import org.watermedia.shaded.schabi.newpipe.extractor.localization.TimeAgoParser;

public abstract class Extractor {
    private final StreamingService service;
    private final LinkHandler linkHandler;
    @Nullable
    private Localization forcedLocalization = null;
    @Nullable
    private ContentCountry forcedContentCountry = null;
    private boolean pageFetched = false;
    private final Downloader downloader;

    protected Extractor(StreamingService service, LinkHandler linkHandler) {
        this.service = Objects.requireNonNull(service, "service is null");
        this.linkHandler = Objects.requireNonNull(linkHandler, "LinkHandler is null");
        this.downloader = Objects.requireNonNull(NewPipe.getDownloader(), "downloader is null");
    }

    @Nonnull
    public LinkHandler getLinkHandler() {
        return this.linkHandler;
    }

    public void fetchPage() throws IOException, ExtractionException {
        if (this.pageFetched) {
            return;
        }
        this.onFetchPage(this.downloader);
        this.pageFetched = true;
    }

    protected void assertPageFetched() {
        if (!this.pageFetched) {
            throw new IllegalStateException("Page is not fetched. Make sure you call fetchPage()");
        }
    }

    protected boolean isPageFetched() {
        return this.pageFetched;
    }

    public abstract void onFetchPage(@Nonnull Downloader var1) throws IOException, ExtractionException;

    @Nonnull
    public String getId() throws ParsingException {
        return this.linkHandler.getId();
    }

    @Nonnull
    public abstract String getName() throws ParsingException;

    @Nonnull
    public String getOriginalUrl() throws ParsingException {
        return this.linkHandler.getOriginalUrl();
    }

    @Nonnull
    public String getUrl() throws ParsingException {
        return this.linkHandler.getUrl();
    }

    @Nonnull
    public String getBaseUrl() throws ParsingException {
        return this.linkHandler.getBaseUrl();
    }

    @Nonnull
    public StreamingService getService() {
        return this.service;
    }

    public int getServiceId() {
        return this.service.getServiceId();
    }

    public Downloader getDownloader() {
        return this.downloader;
    }

    public void forceLocalization(Localization localization) {
        this.forcedLocalization = localization;
    }

    public void forceContentCountry(ContentCountry contentCountry) {
        this.forcedContentCountry = contentCountry;
    }

    @Nonnull
    public Localization getExtractorLocalization() {
        return this.forcedLocalization == null ? this.getService().getLocalization() : this.forcedLocalization;
    }

    @Nonnull
    public ContentCountry getExtractorContentCountry() {
        return this.forcedContentCountry == null ? this.getService().getContentCountry() : this.forcedContentCountry;
    }

    @Nonnull
    public TimeAgoParser getTimeAgoParser() {
        return this.getService().getTimeAgoParser(this.getExtractorLocalization());
    }
}

