/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript.regexp;

import org.watermedia.shaded.mozilla.javascript.Callable;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.ES6Iterator;
import org.watermedia.shaded.mozilla.javascript.ScriptRuntime;
import org.watermedia.shaded.mozilla.javascript.Scriptable;
import org.watermedia.shaded.mozilla.javascript.ScriptableObject;
import org.watermedia.shaded.mozilla.javascript.Undefined;
import org.watermedia.shaded.mozilla.javascript.regexp.NativeRegExp;

public final class NativeRegExpStringIterator
extends ES6Iterator {
    private static final long serialVersionUID = 1L;
    private static final String ITERATOR_TAG = "RegExpStringIterator";
    private Scriptable regexp;
    private String string;
    private boolean global;
    private boolean fullUnicode;
    private boolean nextDone;
    private Object next = null;

    public static void init(ScriptableObject scope, boolean sealed) {
        ES6Iterator.init(scope, sealed, new NativeRegExpStringIterator(), ITERATOR_TAG);
    }

    private NativeRegExpStringIterator() {
    }

    public NativeRegExpStringIterator(Scriptable scope, Scriptable regexp, String string, boolean global, boolean fullUnicode) {
        super(scope, ITERATOR_TAG);
        this.regexp = regexp;
        this.string = string;
        this.global = global;
        this.fullUnicode = fullUnicode;
        this.nextDone = false;
    }

    @Override
    public String getClassName() {
        return "RegExp String Iterator";
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        if (this.nextDone) {
            return true;
        }
        this.next = this.regExpExec(cx, scope);
        if (this.next == null) {
            this.next = Undefined.instance;
            this.nextDone = true;
            return true;
        }
        if (!this.global) {
            this.nextDone = true;
            return false;
        }
        String matchStr = ScriptRuntime.toString(ScriptRuntime.getObjectIndex(this.next, 0.0, cx, scope));
        if (matchStr.isEmpty()) {
            long thisIndex = ScriptRuntime.toLength(ScriptRuntime.getObjectProp(this.regexp, "lastIndex", cx));
            long nextIndex = ScriptRuntime.advanceStringIndex(this.string, thisIndex, this.fullUnicode);
            ScriptRuntime.setObjectProp(this.regexp, "lastIndex", (Object)nextIndex, cx);
        }
        return false;
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        return this.next;
    }

    private Object regExpExec(Context cx, Scriptable scope) {
        Object execMethod = ScriptRuntime.getObjectProp(this.regexp, "exec", cx);
        if (execMethod instanceof Callable) {
            return ((Callable)execMethod).call(cx, scope, this.regexp, new Object[]{this.string});
        }
        return NativeRegExp.js_exec(cx, scope, this.regexp, new Object[]{this.string});
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }
}

