/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript.engine;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.watermedia.shaded.javax.script.ScriptEngine;
import org.watermedia.shaded.javax.script.ScriptEngineFactory;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.engine.RhinoScriptEngine;

public class RhinoScriptEngineFactory
implements ScriptEngineFactory {
    public static final String NAME = "rhino";
    private static final String LANGUAGE = "javascript";
    private static final List<String> NAMES = Arrays.asList("rhino", "Rhino", "javascript", "JavaScript");
    private static final List<String> EXTENSIONS = Collections.singletonList("js");
    private static final List<String> MIME_TYPES = Arrays.asList("application/javascript", "application/ecmascript", "text/javascript", "text/ecmascript");
    private static final String LANGUAGE_VERSION = String.valueOf(200);

    public String getEngineName() {
        return NAME;
    }

    public String getEngineVersion() {
        try (Context cx = Context.enter();){
            String v = cx.getImplementationVersion();
            String string = v == null ? "unknown" : v;
            return string;
        }
    }

    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    public List<String> getMimeTypes() {
        return MIME_TYPES;
    }

    public List<String> getNames() {
        return NAMES;
    }

    public String getLanguageName() {
        return LANGUAGE;
    }

    public String getLanguageVersion() {
        return LANGUAGE_VERSION;
    }

    public Object getParameter(String key) {
        switch (key) {
            case "org.watermedia.shaded.javax.script.engine": {
                return this.getEngineName();
            }
            case "org.watermedia.shaded.javax.script.engine_version": {
                return this.getEngineVersion();
            }
            case "org.watermedia.shaded.javax.script.language": {
                return this.getLanguageName();
            }
            case "org.watermedia.shaded.javax.script.language_version": {
                return this.getLanguageVersion();
            }
            case "org.watermedia.shaded.javax.script.name": {
                return NAME;
            }
            case "THREADING": {
                return null;
            }
        }
        return null;
    }

    public String getMethodCallSyntax(String obj, String m, String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj).append('.').append(m).append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(args[i]);
        }
        sb.append(");");
        return sb.toString();
    }

    public String getOutputStatement(String toDisplay) {
        return "print('" + toDisplay + "');";
    }

    public String getProgram(String ... statements) {
        StringBuilder sb = new StringBuilder();
        for (String stmt : statements) {
            sb.append(stmt).append(";\n");
        }
        return sb.toString();
    }

    public ScriptEngine getScriptEngine() {
        return new RhinoScriptEngine(this);
    }
}

