/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript.ast;

import org.watermedia.shaded.mozilla.javascript.ast.AstNode;
import org.watermedia.shaded.mozilla.javascript.ast.NodeVisitor;

public class KeywordLiteral
extends AstNode {
    public KeywordLiteral() {
    }

    public KeywordLiteral(int pos) {
        super(pos);
    }

    public KeywordLiteral(int pos, int len) {
        super(pos, len);
    }

    public KeywordLiteral(int pos, int len, int nodeType) {
        super(pos, len);
        this.setType(nodeType);
    }

    @Override
    public KeywordLiteral setType(int nodeType) {
        if (nodeType != 48 && nodeType != 79 && nodeType != 47 && nodeType != 50 && nodeType != 49 && nodeType != 174) {
            throw new IllegalArgumentException("Invalid node type: " + nodeType);
        }
        this.type = nodeType;
        return this;
    }

    public boolean isBooleanLiteral() {
        return this.type == 50 || this.type == 49;
    }

    @Override
    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        switch (this.getType()) {
            case 48: {
                sb.append("this");
                break;
            }
            case 79: {
                sb.append("super");
                break;
            }
            case 47: {
                sb.append("null");
                break;
            }
            case 50: {
                sb.append("true");
                break;
            }
            case 49: {
                sb.append("false");
                break;
            }
            case 174: {
                sb.append("debugger;\n");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid keyword literal type: " + this.getType());
            }
        }
        return sb.toString();
    }

    @Override
    public void visit(NodeVisitor v) {
        v.visit(this);
    }
}

