/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.shaded.mozilla.javascript;

import java.util.EnumSet;
import org.watermedia.shaded.mozilla.javascript.BaseFunction;
import org.watermedia.shaded.mozilla.javascript.Context;
import org.watermedia.shaded.mozilla.javascript.DecompilerFlag;
import org.watermedia.shaded.mozilla.javascript.EvaluatorException;
import org.watermedia.shaded.mozilla.javascript.NativeCall;
import org.watermedia.shaded.mozilla.javascript.ScriptRuntime;
import org.watermedia.shaded.mozilla.javascript.Scriptable;
import org.watermedia.shaded.mozilla.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    private static final long serialVersionUID = 8713897114082216401L;

    public final void initScriptFunction(Context cx, Scriptable scope) {
        this.initScriptFunction(cx, scope, this.isGeneratorFunction());
    }

    public final void initScriptFunction(Context cx, Scriptable scope, boolean es6GeneratorFunction) {
        ScriptRuntime.setFunctionProtoAndParent(this, cx, scope, es6GeneratorFunction);
    }

    @Override
    final String decompile(int indent, EnumSet<DecompilerFlag> flags) {
        String rawSource = this.getRawSource();
        if (rawSource != null) {
            return rawSource;
        }
        return super.decompile(indent, flags);
    }

    @Override
    public int getLength() {
        int paramCount = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return paramCount;
        }
        Context cx = Context.getContext();
        NativeCall activation = ScriptRuntime.findFunctionActivation(cx, this);
        if (activation == null) {
            return paramCount;
        }
        return activation.originalArgs.length;
    }

    @Override
    public int getArity() {
        return this.getParamCount();
    }

    @Deprecated
    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getRawSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    public Object resumeGenerator(Context cx, Scriptable scope, int operation, Object state, Object value) {
        throw new EvaluatorException("resumeGenerator() not implemented");
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);

    protected boolean getParamOrVarConst(int index) {
        return false;
    }
}

