/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.tom.peripherals.math.Vec2i;
import com.tom.peripherals.util.IImageIO;
import com.tom.peripherals.util.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NativeImageIO
implements IImageIO {
    @Override
    public Image read(InputStream f) throws IOException {
        try (NativeImage ni = NativeImage.read((InputStream)f);){
            Image i = new Image(ni.getWidth(), ni.getHeight());
            for (int y = 0; y < ni.getHeight(); ++y) {
                for (int x = 0; x < ni.getWidth(); ++x) {
                    int rgb = ni.getPixelRGBA(x, y);
                    int a = rgb >> 24 & 0xFF;
                    int b = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int r = rgb & 0xFF;
                    i.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                }
            }
            Image image = i;
            return image;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Vec2i getSize(InputStream din) throws IOException {
        Vec2i vec2i;
        MemoryStack memorystack;
        ByteBuffer byteBufferIn;
        block9: {
            byteBufferIn = null;
            memorystack = MemoryStack.stackPush();
            byteBufferIn = TextureUtil.readResource((InputStream)din);
            ((Buffer)byteBufferIn).rewind();
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            if (!STBImage.stbi_info_from_memory((ByteBuffer)byteBufferIn, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2)) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            vec2i = new Vec2i(intbuffer.get(0), intbuffer1.get(0));
            if (memorystack == null) break block9;
            memorystack.close();
        }
        MemoryUtil.memFree((Buffer)byteBufferIn);
        return vec2i;
        {
            catch (Throwable throwable) {
                try {
                    if (memorystack != null) {
                        try {
                            memorystack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    MemoryUtil.memFree(byteBufferIn);
                    throw throwable3;
                }
            }
        }
    }

    @Override
    public void write(Image img, OutputStream f) throws IOException {
        try (NativeImage ni = NativeImageIO.createFromBufferedImage(img);){
            f.write(ni.asByteArray());
        }
    }

    public static NativeImage createFromBufferedImage(Image texture) {
        NativeImage ni = new NativeImage(texture.getWidth(), texture.getHeight(), false);
        for (int y = 0; y < texture.getHeight(); ++y) {
            for (int x = 0; x < texture.getWidth(); ++x) {
                int rgb = texture.getRGB(x, y);
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                ni.setPixelRGBA(x, y, a << 24 | b << 16 | g << 8 | r);
            }
        }
        return ni;
    }
}

