/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.top;

import com.tom.peripherals.block.entity.WatchDogTimerBlockEntity;
import com.tom.peripherals.util.InfoUtil;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import java.util.Locale;
import java.util.function.Function;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TheOneProbeHandler
implements Function<ITheOneProbe, Void>,
IProbeInfoProvider {
    private static final ResourceLocation ICONS = ResourceLocation.tryBuild((String)"theoneprobe", (String)"textures/gui/icons.png");
    public static ITheOneProbe theOneProbeImp;

    public static TheOneProbeHandler create() {
        return new TheOneProbeHandler();
    }

    @Override
    public Void apply(ITheOneProbe input) {
        theOneProbeImp = input;
        theOneProbeImp.registerProvider((IProbeInfoProvider)this);
        return null;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity te = world.getBlockEntity(data.getPos());
        if (te instanceof WatchDogTimerBlockEntity) {
            WatchDogTimerBlockEntity be = (WatchDogTimerBlockEntity)te;
            boolean v = (Boolean)Config.harvestStyleVanilla.get();
            int offs = v ? 16 : 0;
            int dim = v ? 13 : 16;
            ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
            IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
            IProbeInfo horizontal = probeInfo.horizontal(alignment);
            if (be.isEnabled()) {
                horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.OK).text((Component)Component.translatable((String)"label.toms_peripherals.wdt.enabled")));
            } else {
                horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(CompoundText.create().style(TextStyleClass.WARNING).text((Component)Component.translatable((String)"label.toms_peripherals.wdt.disabled")));
            }
            probeInfo.text((Component)Component.translatable((String)"label.toms_peripherals.wdt.timeLimit", (Object[])new Object[]{TheOneProbeHandler.ticksToElapsedTime(be.getTimeLimit())}));
            probeInfo.text((Component)Component.translatable((String)"label.toms_peripherals.wdt.timer", (Object[])new Object[]{TheOneProbeHandler.ticksToElapsedTime(be.getTimer())}));
        } else if (te instanceof CableBlockEntity) {
            Object object;
            WiredModemPeripheral modem;
            Object[] nameArray;
            CableBlockEntity be = (CableBlockEntity)te;
            IPeripheral offs = be.getPeripheral(null);
            if (offs instanceof WiredModemPeripheral && (nameArray = (modem = (WiredModemPeripheral)offs).getNameLocal()) != null && nameArray.length == 1 && (object = nameArray[0]) instanceof String) {
                String name = (String)object;
                probeInfo.horizontal().text((Component)Component.translatable((String)"label.toms_peripherals.modem.name")).text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text((Component)Component.literal((String)name)));
            }
        } else if (te instanceof WiredModemFullBlockEntity) {
            WiredModemFullBlockEntity be = (WiredModemFullBlockEntity)te;
            probeInfo.text((Component)Component.translatable((String)"label.toms_peripherals.full_modem.list"));
            boolean hasP = false;
            for (Direction d : Direction.values()) {
                Object object;
                Object[] nameArray;
                WiredModemPeripheral modem = be.getPeripheral(d);
                if (modem == null || (nameArray = modem.getNameLocal()) == null || nameArray.length != 1 || !((object = nameArray[0]) instanceof String)) continue;
                String name = (String)object;
                IProbeInfo h = probeInfo.horizontal().text((Component)Component.translatable((String)("label.toms_peripherals.side." + d.name().toLowerCase(Locale.ROOT))).append(":")).text(CompoundText.create().style(TextStyleClass.HIGHLIGHTED).text((Component)Component.literal((String)name)));
                if (d.getAxis() != Direction.Axis.Y) {
                    h.text((Component)Component.literal((String)("(" + InfoUtil.getDirectionArrow(d.toYRot() - player.yRotO) + ")")));
                }
                hasP = true;
            }
            if (!hasP) {
                probeInfo.text((Component)Component.translatable((String)"label.toms_peripherals.full_modem.none"));
            }
        }
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    public ResourceLocation getID() {
        return ResourceLocation.tryBuild((String)"toms_peripherals", (String)"top");
    }
}

