/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.platform;

import com.tom.peripherals.Content;
import com.tom.peripherals.platform.GameObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class Platform {
    public static final GameObject.GameRegistry<Item> ITEMS = new GameObject.GameRegistry(Registries.ITEM);
    public static final GameObject.GameRegistry<Block> BLOCKS = new GameObject.GameRegistry(Registries.BLOCK);
    public static final GameObject.GameRegistryBE BLOCK_ENTITY = new GameObject.GameRegistryBE();
    public static final DeferredRegister<CreativeModeTab> TAB = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"toms_peripherals");
    public static final GameObject.GameRegistry<MenuType<?>> MENU_TYPE = new GameObject.GameRegistry(Registries.MENU);
    public static final GameObject.GameRegistry<DataComponentType<?>> DATA_COMPONENT_TYPES = new GameObject.GameRegistry(Registries.DATA_COMPONENT_TYPE);
    private static List<Item> tabItems = new ArrayList<Item>();
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MOD_TAB = TAB.register("tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.toms_peripherals.tab")).icon(() -> new ItemStack((ItemLike)Content.gpu.get())).displayItems((p, out) -> tabItems.forEach(arg_0 -> ((CreativeModeTab.Output)out).accept(arg_0))).build());

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        BLOCKS.register(bus);
        BLOCK_ENTITY.register(bus);
        MENU_TYPE.register(bus);
        TAB.register(bus);
        DATA_COMPONENT_TYPES.register(bus);
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static <I extends Item> I addItemToTab(I item) {
        tabItems.add(item);
        return item;
    }
}

