/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.network;

import com.tom.peripherals.network.DataPacket;
import com.tom.peripherals.util.IDataReceiver;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class Network {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("toms_peripherals");
        registrar.playBidirectional(DataPacket.ID, DataPacket.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(Network::handleDataClient, Network::handleDataServer));
    }

    public static void handleDataServer(DataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer sender = (ServerPlayer)context.player();
            if (sender.containerMenu instanceof IDataReceiver) {
                ((IDataReceiver)sender.containerMenu).receive(packet.tag());
            }
        });
    }

    public static void handleDataClient(DataPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (Minecraft.getInstance().screen instanceof IDataReceiver) {
                ((IDataReceiver)Minecraft.getInstance().screen).receive(packet.tag());
            }
        });
    }

    public static void sendToContainer(CompoundTag tag) {
        PacketDistributor.sendToServer((CustomPacketPayload)new DataPacket(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendTo(ServerPlayer pl, CompoundTag tag) {
        PacketDistributor.sendToPlayer((ServerPlayer)pl, (CustomPacketPayload)new DataPacket(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

