/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.menu;

import com.tom.peripherals.Content;
import com.tom.peripherals.block.entity.KeyboardBlockEntity;
import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.util.IDataReceiver;
import dan200.computercraft.shared.container.InvisibleSlot;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class KeyboardMenu
extends AbstractContainerMenu
implements IDataReceiver {
    private KeyboardBlockEntity te;
    private Inventory inv;
    private int randomId;

    public KeyboardMenu(int id, Inventory inv) {
        super(Content.keyboardMenu.get(), id);
        this.inv = inv;
        this.addSlots(inv);
    }

    public KeyboardMenu(int id, Inventory inv, KeyboardBlockEntity te) {
        this(id, inv);
        this.te = te;
        te.onKeyboardOpen(this.randomId);
        this.randomId = (int)(Math.random() * 2.147483647E9);
    }

    private void addSlots(Inventory player) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot((Slot)new InvisibleSlot((Container)player, i));
        }
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.te == null ? true : this.te.menuStillValid(player);
    }

    public void removed(Player p_38940_) {
        super.removed(p_38940_);
        if (this.te != null) {
            this.te.onKeyboardClosed(this.randomId);
        }
    }

    @Override
    public void receive(CompoundTag tag) {
        switch (tag.getString("action")) {
            case "paste": {
                String text = tag.getString("v");
                this.queueEvent("paste", text);
                break;
            }
            case "keyDown": {
                int key = tag.getInt("key");
                boolean rep = tag.getBoolean("r");
                this.queueEvent("key", key, rep);
                break;
            }
            case "keyUp": {
                int key = tag.getInt("key");
                this.queueEvent("key_up", key);
                break;
            }
            case "char": {
                short sh = tag.getShort("char");
                this.queueEvent("char", Character.toString(sh));
                break;
            }
            case "event": {
                this.queueEvent(tag.getString("name"), new Object[0]);
                break;
            }
            case "clickCC": {
                BlockState b;
                int wx = tag.getInt("wx");
                int wy = tag.getInt("wy");
                int wz = tag.getInt("wz");
                double x = tag.getDouble("x");
                double y = tag.getDouble("y");
                double z = tag.getDouble("z");
                byte d = tag.getByte("d");
                Direction dir = Direction.values()[Math.abs(d) % 6];
                BlockPos pos = new BlockPos(wx, wy, wz);
                BlockHitResult hit = new BlockHitResult(new Vec3(x, y, z), dir, pos, false);
                if (!this.te.getLevel().isLoaded(pos) || !(this.te.getBlockPos().distSqr((Vec3i)pos) < 4096.0) || !((b = this.te.getLevel().getBlockState(pos)).getBlock() instanceof MonitorBlock)) break;
                b.useWithoutItem(this.te.getLevel(), this.inv.player, hit);
                break;
            }
            case "monEvent": {
                BlockEntity blockEntity;
                Integer param;
                String ev = tag.getString("event");
                int wx = tag.getInt("wx");
                int wy = tag.getInt("wy");
                int wz = tag.getInt("wz");
                int x = tag.getInt("x");
                int y = tag.getInt("y");
                BlockPos pos = new BlockPos(wx, wy, wz);
                Integer n = param = tag.contains("param") ? Integer.valueOf(tag.getInt("param")) : null;
                if (!this.te.getLevel().isLoaded(pos) || !(this.te.getBlockPos().distSqr((Vec3i)pos) < 4096.0) || !((blockEntity = this.te.getLevel().getBlockEntity(pos)) instanceof MonitorBlockEntity)) break;
                MonitorBlockEntity be = (MonitorBlockEntity)blockEntity;
                be.event(ev, x, y, param);
                break;
            }
        }
    }

    private void queueEvent(String event, Object ... args) {
        this.te.queueEvent(event, args);
    }
}

