/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.math;

import com.tom.peripherals.math.Vec3d;
import com.tom.peripherals.math.Vec4d;

public class Matrix4d {
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Vec3d mul(Vec3d i) {
        Vec3d o = new Vec3d();
        o.x = i.x * this.m00 + i.y * this.m10 + i.z * this.m20 + this.m30;
        o.y = i.x * this.m01 + i.y * this.m11 + i.z * this.m21 + this.m31;
        o.z = i.x * this.m02 + i.y * this.m12 + i.z * this.m22 + this.m32;
        double w = i.x * this.m03 + i.y * this.m13 + i.z * this.m23 + this.m33;
        if (w != 0.0) {
            o.x /= w;
            o.y /= w;
            o.z /= w;
        }
        return o;
    }

    public double mul(Vec3d i, Vec3d o) {
        o.x = i.x * this.m00 + i.y * this.m10 + i.z * this.m20 + this.m30;
        o.y = i.x * this.m01 + i.y * this.m11 + i.z * this.m21 + this.m31;
        o.z = i.x * this.m02 + i.y * this.m12 + i.z * this.m22 + this.m32;
        double w = i.x * this.m03 + i.y * this.m13 + i.z * this.m23 + this.m33;
        if (w != 0.0) {
            o.x /= w;
            o.y /= w;
            o.z /= w;
        }
        return w;
    }

    public void mul(Vec4d i, Vec4d o) {
        o.x = i.x * this.m00 + i.y * this.m10 + i.z * this.m20 + this.m30;
        o.y = i.x * this.m01 + i.y * this.m11 + i.z * this.m21 + this.m31;
        o.z = i.x * this.m02 + i.y * this.m12 + i.z * this.m22 + this.m32;
        o.w = i.x * this.m03 + i.y * this.m13 + i.z * this.m23 + this.m33;
    }

    public Matrix4d(Matrix4d m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m02 = m.m02;
        this.m03 = m.m03;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m12 = m.m12;
        this.m13 = m.m13;
        this.m20 = m.m20;
        this.m21 = m.m21;
        this.m22 = m.m22;
        this.m23 = m.m23;
        this.m30 = m.m30;
        this.m31 = m.m31;
        this.m32 = m.m32;
        this.m33 = m.m33;
    }

    public Matrix4d() {
    }

    public Matrix4d identity() {
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m20 = 0.0;
        this.m30 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m21 = 0.0;
        this.m31 = 0.0;
        this.m02 = 0.0;
        this.m12 = 0.0;
        this.m22 = 1.0;
        this.m32 = 0.0;
        this.m03 = 0.0;
        this.m13 = 0.0;
        this.m23 = 0.0;
        this.m33 = 1.0;
        return this;
    }

    public Matrix4d translate(double x, double y, double z) {
        Matrix4d c = this;
        c.m30 = c.m00 * x + c.m10 * y + c.m20 * z + c.m30;
        c.m31 = c.m01 * x + c.m11 * y + c.m21 * z + c.m31;
        c.m32 = c.m02 * x + c.m12 * y + c.m22 * z + c.m32;
        c.m33 = c.m03 * x + c.m13 * y + c.m23 * z + c.m33;
        return this;
    }

    public Matrix4d scale(double x, double y, double z) {
        this.m00 *= x;
        this.m01 *= x;
        this.m02 *= x;
        this.m03 *= x;
        this.m10 *= y;
        this.m11 *= y;
        this.m12 *= y;
        this.m13 *= y;
        this.m20 *= z;
        this.m21 *= z;
        this.m22 *= z;
        this.m23 *= z;
        return this;
    }

    public Matrix4d rotate(double ang, double x, double y, double z) {
        double s = Math.sin(ang);
        double c = Math.cos(ang);
        double C = 1.0 - c;
        double xx = x * x;
        double xy = x * y;
        double xz = x * z;
        double yy = y * y;
        double yz = y * z;
        double zz = z * z;
        double rm00 = xx * C + c;
        double rm01 = xy * C + z * s;
        double rm02 = xz * C - y * s;
        double rm10 = xy * C - z * s;
        double rm11 = yy * C + c;
        double rm12 = yz * C + x * s;
        double rm20 = xz * C + y * s;
        double rm21 = yz * C - x * s;
        double rm22 = zz * C + c;
        double nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        double nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        double nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        double nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        double nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        double nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        double nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        double nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        this.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        this.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        this.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        this.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        this.m00 = nm00;
        this.m01 = nm01;
        this.m02 = nm02;
        this.m03 = nm03;
        this.m10 = nm10;
        this.m11 = nm11;
        this.m12 = nm12;
        this.m13 = nm13;
        return this;
    }
}

