/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.jade;

import com.tom.peripherals.block.entity.WatchDogTimerBlockEntity;
import com.tom.peripherals.jade.JadePlugin;
import com.tom.peripherals.util.InfoUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum WatchDogTimerProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public ResourceLocation getUid() {
        return JadePlugin.WATCH_DOG_TIMER;
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        WatchDogTimerBlockEntity be = (WatchDogTimerBlockEntity)accessor.getBlockEntity();
        data.putBoolean("en", be.isEnabled());
        data.putInt("limit", be.getTimeLimit());
        data.putInt("timer", be.getTimer());
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        boolean en = accessor.getServerData().getBoolean("en");
        int limit = accessor.getServerData().getInt("limit");
        int timer = accessor.getServerData().getInt("timer");
        tooltip.add((Component)(en ? Component.translatable((String)"label.toms_peripherals.wdt.enabled") : Component.translatable((String)"label.toms_peripherals.wdt.disabled")));
        tooltip.add((Component)Component.translatable((String)"label.toms_peripherals.wdt.timeLimit", (Object[])new Object[]{InfoUtil.ticksToElapsedTime(limit)}));
        tooltip.add((Component)Component.translatable((String)"label.toms_peripherals.wdt.timer", (Object[])new Object[]{InfoUtil.ticksToElapsedTime(timer)}));
    }
}

