/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.item;

import com.tom.peripherals.Content;
import com.tom.peripherals.block.entity.KeyboardBlockEntity;
import com.tom.peripherals.client.ClientUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PortableKeyboardItem
extends Item {
    public PortableKeyboardItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext p_339606_, List<Component> tooltip, TooltipFlag p_49819_) {
        ClientUtil.tooltip("portable_keyboard.info", tooltip, new Object[0]);
        BlockPos pos = (BlockPos)stack.get(Content.boundPosComponent.get());
        if (pos != null) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            tooltip.add((Component)Component.translatable((String)"tooltip.toms_peripherals.portable_keyboard.bound", (Object[])new Object[]{x, y, z}));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        return new InteractionResultHolder(PortableKeyboardItem.openKeyboard(worldIn, playerIn.getItemInHand(handIn), playerIn, handIn), (Object)playerIn.getItemInHand(handIn));
    }

    public static InteractionResult openKeyboard(Level worldIn, ItemStack stack, Player playerIn, InteractionHand handIn) {
        BlockPos pos = (BlockPos)stack.get(Content.boundPosComponent.get());
        if (pos != null) {
            if (!worldIn.isClientSide) {
                if (playerIn.blockPosition().closerThan((Vec3i)pos, 64.0)) {
                    BlockHitResult lookingAt = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, true);
                    BlockState state = worldIn.getBlockState(lookingAt.getBlockPos());
                    if (state.is((Block)Content.keyboard_dongle.get())) {
                        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
                        if (blockEntity instanceof KeyboardBlockEntity) {
                            KeyboardBlockEntity term = (KeyboardBlockEntity)blockEntity;
                            playerIn.openMenu((MenuProvider)term);
                            stack.set(Content.inUseComponent.get(), (Object)true);
                        }
                        return InteractionResult.CONSUME;
                    }
                    playerIn.displayClientMessage((Component)Component.translatable((String)"chat.toms_peripherals.dongle_not_found"), true);
                } else {
                    playerIn.displayClientMessage((Component)Component.translatable((String)"chat.toms_peripherals.dongle_out_of_range"), true);
                }
            } else {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext c) {
        if (c.isSecondaryUseActive()) {
            if (!c.getLevel().isClientSide) {
                BlockPos pos = c.getClickedPos();
                BlockState state = c.getLevel().getBlockState(pos);
                if (state.is((Block)Content.keyboard_dongle.get())) {
                    ItemStack stack = c.getItemInHand();
                    stack.set(Content.boundPosComponent.get(), (Object)pos.immutable());
                    if (c.getPlayer() != null) {
                        c.getPlayer().displayClientMessage((Component)Component.translatable((String)"chat.toms_peripherals.portable_keyboard.bound_success"), true);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void inventoryTick(ItemStack stack, Level p_41405_, Entity player, int p_41407_, boolean p_41408_) {
        Player pl;
        Boolean in = (Boolean)stack.get(Content.inUseComponent.get());
        if (!(in == null || !in.booleanValue() || player instanceof Player && (pl = (Player)player).hasContainerOpen())) {
            stack.set(Content.inUseComponent.get(), (Object)false);
        }
    }
}

