/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu.font;

import com.tom.peripherals.api.LuaException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class Font {
    public static final Font MISSING = new Font();
    public String name;
    public int[][] chars;
    public String chars2;
    public byte[] widths;
    public int fontHeight;
    public int UNKNOWN;

    public static Font load(String name) {
        InputStream s = null;
        s = Font.class.getResourceAsStream(name + ".bin");
        if (s == null) {
            return null;
        }
        try {
            return new Font(s, name);
        }
        catch (IllegalStateException e) {
            if ("CUSTOMFONT".equals(e.getMessage())) {
                return new CustomFont(name);
            }
            throw e;
        }
    }

    public Font(InputStream stream, String name) {
        this.name = name;
        DataInputStream s = new DataInputStream(stream);
        StringBuilder b = new StringBuilder();
        try {
            int i;
            this.fontHeight = s.readByte();
            if (this.fontHeight == -1) {
                throw new IllegalStateException("CUSTOMFONT");
            }
            int size = s.readInt();
            for (i = 0; i < size; ++i) {
                b.append(s.readChar());
            }
            this.widths = new byte[size];
            this.chars = new int[size][this.fontHeight];
            for (i = 0; i < size; ++i) {
                this.widths[i] = s.readByte();
                for (int j = 0; j < this.fontHeight; ++j) {
                    this.chars[i][j] = s.readInt();
                }
            }
            s.close();
        }
        catch (IOException e) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Couldn't read font", e);
        }
        this.chars2 = b.toString();
        this.UNKNOWN = this.chars2.indexOf(63);
        if (this.UNKNOWN == -1) {
            this.UNKNOWN = 0;
        }
    }

    private Font() {
    }

    public Font getFont(Map<String, CustomFont> internalFonts) {
        return this;
    }

    public boolean editable() {
        return false;
    }

    public int freeChars() {
        return 0;
    }

    public void clear() throws LuaException {
        throw new LuaException("Selected font is not modifiable");
    }

    public int addChar(String c, int[] d) throws LuaException {
        throw new LuaException("Selected font is not modifiable");
    }

    public void remove(String c) throws LuaException {
        throw new LuaException("Selected font is not modifiable");
    }

    public static class CustomFont
    extends Font {
        public CustomFont(String name) {
            this.name = name;
        }

        public CustomFont(CustomFont s) {
            this.name = s.name;
            this.fontHeight = 16;
            this.UNKNOWN = 0;
            this.widths = new byte[256];
            this.chars2 = String.join((CharSequence)"", Collections.nCopies(this.widths.length, "\u0000"));
            Arrays.fill(this.widths, (byte)1);
            this.chars = new int[this.widths.length][this.fontHeight];
        }

        @Override
        public Font getFont(Map<String, CustomFont> internalFonts) {
            CustomFont f = internalFonts.get(this.name);
            if (f == null) {
                f = new CustomFont(this);
                internalFonts.put(this.name, f);
            }
            return f;
        }

        @Override
        public boolean editable() {
            return true;
        }

        @Override
        public int freeChars() {
            return this.chars2.chars().filter(c -> c == 0).map(__ -> 1).sum();
        }

        @Override
        public int addChar(String c, int[] d) throws LuaException {
            int i;
            char cIn = c.charAt(0);
            for (i = 0; i < this.chars2.length(); ++i) {
                if (this.chars2.charAt(i) != cIn) continue;
                throw new LuaException("Character already exists in sprite");
            }
            for (i = 0; i < this.chars2.length(); ++i) {
                if (this.chars2.charAt(i) != '\u0000') continue;
                StringBuilder b = new StringBuilder(this.chars2);
                b.setCharAt(i, cIn);
                this.chars2 = b.toString();
                this.widths[i] = (byte)d[0];
                System.arraycopy(d, 1, this.chars[i], 0, 16);
                return i + 1;
            }
            throw new LuaException("Sprite is full");
        }

        @Override
        public void remove(String c) throws LuaException {
            char cIn = c.charAt(0);
            for (int i = 0; i < this.chars2.length(); ++i) {
                if (this.chars2.charAt(i) != cIn) continue;
                StringBuilder b = new StringBuilder(this.chars2);
                b.setCharAt(i, '\u0000');
                this.chars2 = b.toString();
                return;
            }
            throw new LuaException("Character not found");
        }

        @Override
        public void clear() throws LuaException {
            Arrays.fill(this.widths, (byte)1);
            this.chars = new int[this.widths.length][this.fontHeight];
            this.chars2 = String.join((CharSequence)"", Collections.nCopies(this.widths.length, "\u0000"));
        }
    }
}

