/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.gpu.Triangle;
import com.tom.peripherals.math.Matrix4d;
import com.tom.peripherals.math.Vec2d;
import com.tom.peripherals.math.Vec3d;
import com.tom.peripherals.math.Vec4d;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public interface TriBuilder {
    public void append(Vec3d var1);

    public void setUV(Vec2d var1);

    public void setColor(Vec4d var1);

    public void finish() throws LuaException;

    public static TriBuilder builder(int mode, List<Triangle> list, Supplier<Matrix4d> mm, IntSupplier boundTexID) throws LuaException {
        switch (mode) {
            case 4: {
                return new Default(list, mm, boundTexID);
            }
        }
        throw new LuaException("Unknown build mode: " + mode);
    }

    public static class Default
    implements TriBuilder {
        private List<Triangle> list;
        private Supplier<Matrix4d> mm;
        private IntSupplier boundTexID;
        private int p = -1;
        private Vec3d[] v = new Vec3d[3];
        private Vec4d[] c = new Vec4d[3];
        private Vec2d[] t = new Vec2d[3];

        public Default(List<Triangle> list, Supplier<Matrix4d> mm, IntSupplier boundTexID) {
            this.list = list;
            this.mm = mm;
            this.boundTexID = boundTexID;
        }

        @Override
        public void setUV(Vec2d uv) {
            if (this.p != -1) {
                this.t[this.p] = uv;
            }
        }

        @Override
        public void setColor(Vec4d color) {
            if (this.p != -1) {
                this.c[this.p] = color;
            }
        }

        @Override
        public void append(Vec3d vert) {
            if (this.p >= 2) {
                this.buildTri();
            }
            this.v[++this.p] = this.mm.get().mul(vert);
        }

        @Override
        public void finish() throws LuaException {
            if (this.p != -1 && this.p != 2) {
                throw new LuaException("Incomplete triangle");
            }
            this.buildTri();
        }

        private void buildTri() {
            this.list.add(new Triangle(this.v, this.c, this.t, this.boundTexID.getAsInt()));
            this.v = new Vec3d[3];
            this.c = new Vec4d[3];
            this.t = new Vec2d[3];
            this.p = -1;
        }
    }
}

