/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.screen.TextureCacheImpl;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class MonitorBlockEntityRenderer
implements BlockEntityRenderer<MonitorBlockEntity> {
    public MonitorBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(MonitorBlockEntity te, float partical, PoseStack stack, MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        ResourceLocation tex;
        if (te.screen.length == 0) {
            return;
        }
        if (te.clientCache == null) {
            te.clientCache = new TextureCacheImpl(te);
        }
        if ((tex = te.clientCache.getTexture()) == null) {
            return;
        }
        stack.pushPose();
        Direction facing = te.getDirection();
        stack.translate(0.5, 0.5, 0.5);
        if (facing.getAxis() != Direction.Axis.Y) {
            stack.mulPose(Axis.YP.rotationDegrees(-facing.toYRot()));
        } else {
            stack.mulPose(Axis.XP.rotationDegrees((float)(-facing.getStepY() * 90)));
        }
        stack.translate(-0.5, -0.5, -0.5);
        PoseStack.Pose pose = stack.last();
        Matrix4f mat = stack.last().pose();
        VertexConsumer buf = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)tex));
        float z = 1.001f;
        buf.addVertex(mat, 1.0f, 1.0f, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(pose, 0.0f, 0.0f, 1.0f);
        buf.addVertex(mat, 0.0f, 1.0f, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(pose, 0.0f, 0.0f, 1.0f);
        buf.addVertex(mat, 0.0f, 0.0f, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 1.0f).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(pose, 0.0f, 0.0f, 1.0f);
        buf.addVertex(mat, 1.0f, 0.0f, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 1.0f).setOverlay(pPackedOverlay).setLight(pPackedLight).setNormal(pose, 0.0f, 0.0f, 1.0f);
        stack.popPose();
    }
}

