/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.client;

import com.tom.peripherals.client.KeyboardWidget;
import com.tom.peripherals.menu.KeyboardMenu;
import java.util.ArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class KeyboardScreen
extends Screen
implements MenuAccess<KeyboardMenu> {
    private final KeyboardMenu menu;
    private KeyboardWidget keyHandler;

    public KeyboardScreen(KeyboardMenu menu, Inventory inv, Component p_96550_) {
        super(p_96550_);
        this.menu = menu;
    }

    public KeyboardMenu getMenu() {
        return this.menu;
    }

    protected void init() {
        this.minecraft.mouseHandler.grabMouse();
        this.minecraft.screen = this;
        KeyMapping.releaseAll();
        super.init();
        this.keyHandler = (KeyboardWidget)this.addRenderableWidget((GuiEventListener)new KeyboardWidget());
        this.setFocused((GuiEventListener)this.keyHandler);
    }

    public final void tick() {
        super.tick();
        this.keyHandler.update();
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        return super.mouseScrolled(d, e, f, g);
    }

    public void onClose() {
        this.keyHandler.release();
        this.minecraft.player.closeContainer();
        super.onClose();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public final boolean keyPressed(int key, int scancode, int modifiers) {
        return key == 258 && this.getFocused() != null && this.getFocused() == this.keyHandler ? this.getFocused().keyPressed(key, scancode, modifiers) : super.keyPressed(key, scancode, modifiers);
    }

    public void render(GuiGraphics transform, int mouseX, int mouseY, float partialTicks) {
        super.render(transform, mouseX, mouseY, partialTicks);
        Font font = this.minecraft.font;
        ArrayList lines = new ArrayList();
        int w = (int)((double)this.width * 0.8);
        lines.addAll(font.split((FormattedText)Component.translatable((String)"label.toms_peripherals.keyboard.open"), w));
        lines.addAll(font.split((FormattedText)this.keyHandler.getInfo(), w));
        int y = 10;
        for (FormattedCharSequence line : lines) {
            transform.drawString(font, line, this.width / 2 - this.minecraft.font.width(line) / 2, y, 0xFFFFFF, true);
            y += 9;
        }
    }

    public void renderBackground(GuiGraphics p_283688_, int p_296369_, int p_296477_, float p_294317_) {
    }
}

