/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.Content;
import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.api.ObjectWrapper;
import com.tom.peripherals.api.TMLuaObject;
import com.tom.peripherals.cc.ComputerControl;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.platform.Platform;
import com.tom.peripherals.util.ParamCheck;
import com.tom.peripherals.util.TickerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WatchDogTimerBlockEntity
extends AbstractPeripheralBlockEntity
implements TickerUtil.TickableServer {
    private ObjectWrapper peripheral;
    private boolean enabled;
    private int timeLimit;
    private int timer;

    public WatchDogTimerBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)Content.wdtBE.get(), p_155229_, p_155230_);
    }

    @Override
    public void updateServer() {
        if (!this.enabled) {
            return;
        }
        if (this.timer > this.timeLimit) {
            this.enabled = false;
            Direction facting = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
            BlockPos onPos = this.getBlockPos().relative(facting);
            ComputerControl.restartComputerAt(this.level, onPos);
        } else {
            ++this.timer;
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider p_338445_) {
        super.loadAdditional(tag, p_338445_);
        this.enabled = tag.getBoolean("enabled");
        this.timeLimit = tag.getInt("timeLimit");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("enabled", this.enabled);
        tag.putInt("timeLimit", this.timeLimit);
    }

    @Override
    public ObjectWrapper getPeripheral() {
        if (this.peripheral == null) {
            this.peripheral = new ObjectWrapper("tm_wdt", new WDT());
        }
        return this.peripheral;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public int getTimer() {
        return this.timer;
    }

    public class WDT
    extends TMLuaObject {
        @LuaMethod
        public boolean isEnabled() {
            return WatchDogTimerBlockEntity.this.enabled;
        }

        @LuaMethod
        public int getTimeout() {
            return WatchDogTimerBlockEntity.this.timeLimit;
        }

        @LuaMethod
        public void setEnabled(Object[] a) throws LuaException {
            if (a.length < 1) {
                throw new LuaException("Too few arguments (expected enable)");
            }
            boolean enable = ParamCheck.getBoolean(a, 0);
            Platform.getServer().execute(() -> {
                WatchDogTimerBlockEntity.this.enabled = enable;
                WatchDogTimerBlockEntity.this.timer = 0;
                WatchDogTimerBlockEntity.this.setChanged();
            });
        }

        @LuaMethod
        public void setTimeout(Object[] a) throws LuaException {
            if (WatchDogTimerBlockEntity.this.enabled) {
                throw new LuaException("Can't edit timeout value while the timer is enabled");
            }
            if (a.length < 1) {
                throw new LuaException("Too few arguments (expected enable)");
            }
            int time = ParamCheck.getInt(a, 0);
            if (time < 20) {
                throw new LuaException("Bad argument #1 (expected value must be larger than 20 ticks)");
            }
            Platform.getServer().execute(() -> {
                WatchDogTimerBlockEntity.this.timeLimit = time;
                WatchDogTimerBlockEntity.this.timer = 0;
                WatchDogTimerBlockEntity.this.setChanged();
            });
        }

        @LuaMethod
        public void reset() throws LuaException {
            Platform.getServer().execute(() -> {
                WatchDogTimerBlockEntity.this.timer = 0;
            });
        }
    }
}

