/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.Content;
import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.api.ObjectWrapper;
import com.tom.peripherals.api.TMLuaObject;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.util.TickerUtil;
import dan200.computercraft.impl.BundledRedstone;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RedstonePortBlockEntity
extends AbstractPeripheralBlockEntity
implements TickerUtil.TickableServer {
    private static final Object[] SIDES = Arrays.stream(Direction.values()).map(e -> e.getSerializedName()).toArray();
    private ObjectWrapper peripheral;
    private boolean internalOutputChanged = false;
    private final int[] internalOutput = new int[6];
    private final int[] internalBundledOutput = new int[6];
    private final int[] externalOutput = new int[6];
    private final int[] externalBundledOutput = new int[6];
    private boolean inputChanged = false;
    private final int[] input = new int[6];
    private final int[] bundledInput = new int[6];

    public RedstonePortBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)Content.redstonePortBE.get(), p_155229_, p_155230_);
    }

    @Override
    public ObjectWrapper getPeripheral() {
        if (this.peripheral == null) {
            this.peripheral = new ObjectWrapper("tm_rsPort", new RSPort());
        }
        return this.peripheral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateOutput() {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            if (!this.internalOutputChanged) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            boolean changed = false;
            for (int i = 0; i < 6; ++i) {
                if (this.externalOutput[i] != this.internalOutput[i]) {
                    this.externalOutput[i] = this.internalOutput[i];
                    changed = true;
                }
                if (this.externalBundledOutput[i] == this.internalBundledOutput[i]) continue;
                this.externalBundledOutput[i] = this.internalBundledOutput[i];
                changed = true;
            }
            this.internalOutputChanged = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return changed;
        }
    }

    @Override
    public void updateServer() {
        if (this.inputChanged) {
            this.inputChanged = false;
            this.getPeripheral().queueEvent("tm_redstone", new Object[0]);
        }
        if (this.updateOutput()) {
            for (Direction dir : DirectionUtil.FACINGS) {
                RedstoneUtil.propagateRedstoneOutput((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (Direction)dir);
            }
            this.updateRedstoneInputs();
        }
    }

    public int getInput(Direction side) {
        return this.input[side.ordinal()];
    }

    public int getBundledInput(Direction side) {
        return this.bundledInput[side.ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutput(Direction side, int output) {
        int index = side.ordinal();
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            if (this.internalOutput[index] != output) {
                this.internalOutput[index] = output;
                this.internalOutputChanged = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutput(Direction side) {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.internalOutput[side.ordinal()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundledOutput(Direction side, int output) {
        int index = side.ordinal();
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            if (this.internalBundledOutput[index] != output) {
                this.internalBundledOutput[index] = output;
                this.internalOutputChanged = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBundledOutput(Direction side) {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.internalBundledOutput[side.ordinal()];
        }
    }

    public int getExternalRedstoneOutput(Direction side) {
        return this.externalOutput[side.ordinal()];
    }

    public int getExternalBundledRedstoneOutput(Direction side) {
        return this.externalBundledOutput[side.ordinal()];
    }

    public void setRedstoneInput(Direction side, int level) {
        int index = side.ordinal();
        if (this.input[index] != level) {
            this.input[index] = level;
            this.inputChanged = true;
        }
    }

    public void setBundledRedstoneInput(Direction side, int combination) {
        int index = side.ordinal();
        if (this.bundledInput[index] != combination) {
            this.bundledInput[index] = combination;
            this.inputChanged = true;
        }
    }

    private void updateRedstoneInput(Direction dir, BlockPos targetPos) {
        Direction offsetSide = dir.getOpposite();
        this.setRedstoneInput(dir, RedstoneUtil.getRedstoneInput((Level)this.level, (BlockPos)targetPos, (Direction)dir));
        this.setBundledRedstoneInput(dir, BundledRedstone.getOutput((Level)this.getLevel(), (BlockPos)targetPos, (Direction)offsetSide));
    }

    private void updateRedstoneInputs() {
        BlockPos pos = this.getBlockPos();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(dir, pos.relative(dir));
        }
    }

    public void neighborChanged(BlockPos neighbour) {
        this.updateInputAt(neighbour);
    }

    private void updateInputAt(BlockPos neighbour) {
        for (Direction dir : DirectionUtil.FACINGS) {
            BlockPos offset = this.getBlockPos().relative(dir);
            if (!offset.equals((Object)neighbour)) continue;
            this.updateRedstoneInput(dir, offset);
            return;
        }
        this.updateRedstoneInputs();
    }

    public class RSPort
    extends TMLuaObject {
        @LuaMethod
        public Object[] getSides() throws LuaException {
            return SIDES;
        }

        @LuaMethod
        public boolean getInput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getInput(this.getDir(args[0])) > 0;
        }

        @LuaMethod
        public int getAnalogInput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getInput(this.getDir(args[0]));
        }

        @LuaMethod
        public int getAnalogueInput(Object[] args) throws LuaException {
            return this.getAnalogInput(args);
        }

        @LuaMethod
        public int getBundledInput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getBundledInput(this.getDir(args[0]));
        }

        @LuaMethod
        public boolean getOutput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getOutput(this.getDir(args[0])) > 0;
        }

        @LuaMethod
        public int getAnalogOutput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getOutput(this.getDir(args[0]));
        }

        @LuaMethod
        public int getAnalogueOutput(Object[] args) throws LuaException {
            return this.getAnalogOutput(args);
        }

        @LuaMethod
        public int getBundledOutput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getBundledOutput(this.getDir(args[0]));
        }

        @LuaMethod
        public void setOutput(Object[] args) throws LuaException {
            if (args.length < 2) {
                throw new LuaException("Too few arguments (expected direction, value)");
            }
            Object object = args[1];
            if (!(object instanceof Boolean)) {
                throw new LuaException("Bad argument #2 (expected Boolean)");
            }
            Boolean v = (Boolean)object;
            RedstonePortBlockEntity.this.setOutput(this.getDir(args[0]), v != false ? 15 : 0);
        }

        @LuaMethod
        public void setAnalogOutput(Object[] args) throws LuaException {
            if (args.length < 2) {
                throw new LuaException("Too few arguments (expected direction, value)");
            }
            Object object = args[1];
            if (!(object instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected Number)");
            }
            Double v = (Double)object;
            Direction dir = this.getDir(args[0]);
            int out = Mth.floor((double)v);
            if (out < 0 || out > 15) {
                throw new LuaException("Bad argument #2: Expected number in range 0-15");
            }
            RedstonePortBlockEntity.this.setOutput(dir, out);
        }

        @LuaMethod
        public void setAnalogueOutput(Object[] args) throws LuaException {
            this.setAnalogOutput(args);
        }

        @LuaMethod
        public void setBundledOutput(Object[] args) throws LuaException {
            if (args.length < 2) {
                throw new LuaException("Too few arguments (expected direction, value)");
            }
            Object object = args[1];
            if (!(object instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected Number)");
            }
            Double v = (Double)object;
            Direction dir = this.getDir(args[0]);
            int out = Mth.floor((double)v);
            RedstonePortBlockEntity.this.setBundledOutput(dir, out);
        }

        @LuaMethod
        public boolean testBundledInput(Object[] args) throws LuaException {
            if (args.length < 2) {
                throw new LuaException("Too few arguments (expected direction, mask)");
            }
            Object object = args[1];
            if (!(object instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected Number)");
            }
            Double md = (Double)object;
            int value = RedstonePortBlockEntity.this.getBundledInput(this.getDir(args[0]));
            int mask = Mth.floor((double)md);
            return (value & mask) == mask;
        }

        private Direction getDir(Object in) throws LuaException {
            String side = String.valueOf(in);
            Direction dir = null;
            for (Direction d : Direction.values()) {
                if (!d.getName().equalsIgnoreCase(side)) continue;
                dir = d;
                break;
            }
            if (dir == null) {
                throw new LuaException("Bad argument #1: expected one of: up, down, north, south, east, west");
            }
            return dir;
        }
    }
}

