/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.Content;
import com.tom.peripherals.block.entity.GPUBlockEntity;
import com.tom.peripherals.math.Vec2i;
import com.tom.peripherals.screen.TextureCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MonitorBlockEntity
extends BlockEntity {
    private BlockPos gpuPos;
    public TextureCache clientCache;
    public int[] screen = new int[0];
    public int width;

    public MonitorBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)Content.monitorBE.get(), p_155229_, p_155230_);
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING);
    }

    public BlockPos getOffset(int x, int y, Direction d) {
        int xCoord = this.worldPosition.getX();
        int yCoord = this.worldPosition.getY();
        int zCoord = this.worldPosition.getZ();
        switch (d) {
            case DOWN: {
                return new BlockPos(xCoord + x, yCoord, zCoord + y);
            }
            case UP: {
                return new BlockPos(xCoord + x, yCoord, zCoord - y);
            }
            case NORTH: {
                return new BlockPos(xCoord - x, yCoord + y, zCoord);
            }
            case SOUTH: {
                return new BlockPos(xCoord + x, yCoord + y, zCoord);
            }
            case WEST: {
                return new BlockPos(xCoord, yCoord + y, zCoord + x);
            }
            case EAST: {
                return new BlockPos(xCoord, yCoord + y, zCoord - x);
            }
        }
        return new BlockPos(xCoord, yCoord, zCoord);
    }

    public MonitorBlockEntity connect(BlockPos gpuPos) {
        this.gpuPos = gpuPos;
        return this;
    }

    public void sync() {
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public void onBlockActivated(Direction side, double x, double y, double z, boolean sneak) {
        BlockEntity tile;
        if (this.getDirection() == side && this.gpuPos != null && (tile = this.level.getBlockEntity(this.gpuPos)) != null && tile instanceof GPUBlockEntity) {
            GPUBlockEntity gpu = (GPUBlockEntity)tile;
            Vec2i c = this.getMonitorPixel(side, x, y, z);
            gpu.monitorClick(this, c.x, c.y, sneak);
        }
    }

    public Vec2i getMonitorPixel(Direction side, double x, double y, double z) {
        int yP;
        int xP;
        if (side.getAxis() != Direction.Axis.Y) {
            double yPos = 1.0 - y;
            double xPos = (double)Math.abs(side.getStepZ()) * x + (double)Math.abs(side.getStepX()) * z;
            if (side.getAxisDirection() == Direction.AxisDirection.NEGATIVE != (side.getAxis() == Direction.Axis.X)) {
                xPos = 1.0 - xPos;
            }
            xP = Mth.floor((double)(xPos * (double)this.width));
            yP = Mth.floor((double)(yPos * (double)this.width));
        } else {
            double yPos = side == Direction.DOWN ? 1.0 - z : z;
            xP = Mth.floor((double)(x * (double)this.width));
            yP = Mth.floor((double)(yPos * (double)this.width));
        }
        return new Vec2i(xP, yP);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        CompoundTag tag = new CompoundTag();
        tag.putIntArray("s", this.screen);
        tag.putShort("w", (short)this.width);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider p_338445_) {
        super.loadAdditional(compoundTag, p_338445_);
        if (compoundTag.contains("s")) {
            this.screen = compoundTag.getIntArray("s");
            this.width = compoundTag.getShort("w");
            if (this.clientCache != null) {
                this.clientCache.invalidate();
            }
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.clientCache != null) {
            this.clientCache.cleanup();
        }
        this.clientCache = null;
    }

    public void event(String ev, int x, int y, Integer param) {
        if (this.gpuPos == null) {
            return;
        }
        BlockEntity tile = this.level.getBlockEntity(this.gpuPos);
        if (tile != null && tile instanceof GPUBlockEntity) {
            GPUBlockEntity gpu = (GPUBlockEntity)tile;
            gpu.monitorEvent(this, ev, x, y, param);
        }
    }
}

