/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block;

import com.tom.peripherals.Content;
import com.tom.peripherals.block.IForgeBlock;
import com.tom.peripherals.block.entity.RedstonePortBlockEntity;
import com.tom.peripherals.client.ClientUtil;
import com.tom.peripherals.util.TickerUtil;
import dan200.computercraft.shared.common.IBundledRedstoneBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class RedstonePortBlock
extends Block
implements EntityBlock,
IForgeBlock,
IBundledRedstoneBlock {
    public RedstonePortBlock() {
        super(BlockBehaviour.Properties.of().mapColor(DyeColor.RED).sound(SoundType.METAL).strength(5.0f).isRedstoneConductor((a, b, c) -> false));
    }

    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return ((BlockEntityType)Content.redstonePortBE.get()).create(p_153215_, p_153216_);
    }

    public final void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean isMoving) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof RedstonePortBlockEntity) {
            RedstonePortBlockEntity te = (RedstonePortBlockEntity)be;
            te.neighborChanged(neighbourPos);
        }
    }

    @Override
    public final void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbour) {
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof RedstonePortBlockEntity) {
            RedstonePortBlockEntity te = (RedstonePortBlockEntity)be;
            te.neighborChanged(neighbour);
        }
    }

    @Override
    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction incomingSide) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof RedstonePortBlockEntity)) {
            return 0;
        }
        RedstonePortBlockEntity te = (RedstonePortBlockEntity)entity;
        return te.getExternalRedstoneOutput(incomingSide.getOpposite());
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction incomingSide) {
        return this.getDirectSignal(state, world, pos, incomingSide);
    }

    public int getBundledRedstoneOutput(Level world, BlockPos pos, Direction side) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof RedstonePortBlockEntity)) {
            return 0;
        }
        RedstonePortBlockEntity te = (RedstonePortBlockEntity)entity;
        return te.getExternalBundledRedstoneOutput(side);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTicker(world, false, true);
    }

    public void appendHoverText(ItemStack p_49816_, Item.TooltipContext p_339606_, List<Component> tooltip, TooltipFlag p_49819_) {
        ClientUtil.tooltip("redstone_port", tooltip, new Object[0]);
    }
}

