/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block;

import com.tom.peripherals.Content;
import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.client.ClientUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MonitorBlock
extends Block
implements EntityBlock {
    public MonitorBlock() {
        super(BlockBehaviour.Properties.of().mapColor(DyeColor.WHITE).sound(SoundType.GLASS).lightLevel(b -> 12).strength(5.0f).noOcclusion());
    }

    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return ((BlockEntityType)Content.monitorBE.get()).create(p_153215_, p_153216_);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof MonitorBlockEntity) {
            MonitorBlockEntity te = (MonitorBlockEntity)blockEntity;
            te.onBlockActivated(hit.getDirection(), hit.getLocation().x - (double)pos.getX(), hit.getLocation().y - (double)pos.getY(), hit.getLocation().z - (double)pos.getZ(), player.isSecondaryUseActive());
        }
        return state.getValue((Property)BlockStateProperties.FACING) == hit.getDirection() ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack p_49816_, Item.TooltipContext p_339606_, List<Component> tooltip, TooltipFlag p_49819_) {
        ClientUtil.tooltip("monitor", tooltip, new Object[0]);
    }
}

