/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.api;

import com.tom.peripherals.api.IComputer;
import com.tom.peripherals.api.ITMLuaObject;
import com.tom.peripherals.api.ITMPeripheral;
import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.function.ThrowingTriFunction;
import com.tom.peripherals.util.Pair;
import java.util.HashMap;
import java.util.Map;

public class TMLuaObject
implements ITMLuaObject {
    private static Map<Class, Pair<String[], Map<String, ThrowingTriFunction<Object, IComputer, Object[], Object[], LuaException>>>> callCache = new HashMap<Class, Pair<String[], Map<String, ThrowingTriFunction<Object, IComputer, Object[], Object[], LuaException>>>>();
    Pair<String[], Map<String, ThrowingTriFunction<Object, IComputer, Object[], Object[], LuaException>>> call = callCache.computeIfAbsent(this.getClass(), c -> {
        Map<String, ThrowingTriFunction<Object, IComputer, Object[], Object[], LuaException>> map = ITMPeripheral.findLuaMethods(c);
        return Pair.of((String[])map.keySet().stream().toArray(String[]::new), map);
    });

    @Override
    public String[] getMethodNames() {
        return this.call.getKey();
    }

    @Override
    public Object[] call(IComputer computer, String method, Object[] args) throws LuaException {
        ThrowingTriFunction<Object, IComputer, Object[], Object[], LuaException> c = this.call.getValue().get(method);
        if (c == null) {
            throw new LuaException("No such method: " + method);
        }
        try {
            return c.apply(this, computer, args);
        }
        catch (LuaException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new LuaException("Java Exception: " + e.toString());
        }
    }

    public Object[] callInt(IComputer computer, String method, Object[] args) throws LuaException, NoSuchMethodException {
        ThrowingTriFunction<Object, IComputer, Object[], Object[], LuaException> c = this.call.getValue().get(method);
        if (c == null) {
            throw new NoSuchMethodException(method);
        }
        return c.apply(this, computer, args);
    }
}

