/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals;

import com.mojang.logging.LogUtils;
import com.tom.peripherals.Client;
import com.tom.peripherals.Config;
import com.tom.peripherals.Content;
import com.tom.peripherals.ForgeConfig;
import com.tom.peripherals.gpu.font.FontManager;
import com.tom.peripherals.network.Network;
import com.tom.peripherals.platform.Platform;
import com.tom.peripherals.top.TheOneProbeHandler;
import com.tom.peripherals.util.ImageIO;
import com.tom.peripherals.util.NativeImageIO;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.slf4j.Logger;

@Mod(value="toms_peripherals")
public class PeripheralsMod {
    public static final String ID = "toms_peripherals";
    public static final Logger LOGGER = LogUtils.getLogger();

    public PeripheralsMod(ModContainer mc, IEventBus bus) {
        bus.addListener(this::setup);
        bus.addListener(this::doClientStuff);
        bus.addListener(this::enqueueIMC);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Client.preInit(mc, bus);
        }
        mc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        mc.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        bus.register(ForgeConfig.class);
        bus.register(Network.class);
        bus.addListener(this::registerCapabilities);
        Content.init();
        Platform.register(bus);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        Client.setup();
        ImageIO.handler = new NativeImageIO();
    }

    private void setup(FMLCommonSetupEvent e) {
        FontManager.init();
    }

    public void enqueueIMC(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> TheOneProbeHandler.create());
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)Content.gpuBE.get(), (be, side) -> be.getCCPeripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)Content.wdtBE.get(), (be, side) -> be.getCCPeripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)Content.redstonePortBE.get(), (be, side) -> be.getCCPeripheral());
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)Content.keyboardBE.get(), (be, side) -> be.getCCPeripheral());
    }
}

