/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.jei.ingredient;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.mehvahdjukaar.jeed.plugin.jei.JEIPlugin;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EffectInstanceHelper
implements IIngredientHelper<MobEffectInstance> {
    public IIngredientType<MobEffectInstance> getIngredientType() {
        return JEIPlugin.EFFECT_INGREDIENT_TYPE;
    }

    public String getDisplayName(MobEffectInstance ingredient) {
        Component displayName = ((MobEffect)ingredient.getEffect().value()).getDisplayName();
        return displayName.getString();
    }

    public Object getUid(MobEffectInstance ingredient, UidContext context) {
        return "effect:" + String.valueOf(this.getResourceLocation(ingredient));
    }

    public String getUniqueId(MobEffectInstance ingredient, UidContext uidContext) {
        return "effect:" + String.valueOf(this.getResourceLocation(ingredient));
    }

    public ResourceLocation getResourceLocation(MobEffectInstance ingredient) {
        return ((ResourceKey)ingredient.getEffect().unwrapKey().get()).location();
    }

    public Iterable<Integer> getColors(MobEffectInstance ingredient) {
        return Collections.singletonList(((MobEffect)ingredient.getEffect().value()).getColor());
    }

    public ItemStack getCheatItemStack(MobEffectInstance ingredient) {
        ItemStack item = new ItemStack((ItemLike)Items.POTION);
        PotionContents potionContents = new PotionContents(Optional.empty(), Optional.of(((MobEffect)ingredient.getEffect().value()).getColor()), Collections.singletonList(this.normalize(ingredient)));
        item.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        return item;
    }

    public MobEffectInstance normalize(MobEffectInstance value) {
        return new MobEffectInstance(value.getEffect(), 600, 0, value.isAmbient(), value.isVisible(), value.showIcon(), value.hiddenEffect);
    }

    public Stream<ResourceLocation> getTagStream(MobEffectInstance ingredient) {
        return ingredient.getEffect().tags().map(TagKey::location);
    }

    public MobEffectInstance copyIngredient(MobEffectInstance ingredient) {
        return new MobEffectInstance(ingredient.getEffect(), ingredient.getDuration(), ingredient.getAmplifier(), ingredient.isAmbient(), ingredient.isVisible(), ingredient.showIcon(), ingredient.hiddenEffect);
    }

    public MobEffectInstance normalizeIngredient(MobEffectInstance ingredient) {
        return new MobEffectInstance(ingredient.getEffect(), 600);
    }

    public String getErrorInfo(@Nullable MobEffectInstance ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(EffectInstance.class);
        MobEffect effect = (MobEffect)ingredient.getEffect().value();
        if (effect != null) {
            Component displayName = effect.getDisplayName();
            toStringHelper.add("Effect", (Object)displayName.getString());
        } else {
            toStringHelper.add("Effect", (Object)"null");
        }
        toStringHelper.add("Duration", ingredient.getDuration());
        toStringHelper.add("Amplifier", ingredient.getAmplifier());
        return toStringHelper.toString();
    }
}

