/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.power.ILowLoadMachine;
import mrtjp.projectred.core.power.ILowLoadPowerLine;
import mrtjp.projectred.core.power.IPowerConductorSource;
import mrtjp.projectred.core.power.PowerConductor;
import mrtjp.projectred.core.tile.BasePoweredBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class LowLoadPoweredBlockEntity
extends BasePoweredBlockEntity
implements ILowLoadMachine {
    protected final PowerConductor conductor = new PowerConductor((IPowerConductorSource)this, 0.01, 160.0);
    private int chargeFlow = 0;

    public LowLoadPoweredBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveToNBT(tag, lookupProvider);
        this.conductor.save(tag);
        tag.putInt("chargeFlow", this.chargeFlow);
    }

    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadFromNBT(tag, lookupProvider);
        this.conductor.load(tag);
        this.chargeFlow = tag.getInt("chargeFlow");
    }

    public void tick() {
        if (this.getLevel().isClientSide) {
            return;
        }
        this.conductor.tick();
        this.chargeFlow <<= 1;
        if (this.canConductorWork()) {
            this.chargeFlow |= 1;
        }
    }

    public boolean canConnectPart(IConnectable part, int s, int edgeRot) {
        if (part instanceof ILowLoadMachine) {
            return true;
        }
        return part instanceof ILowLoadPowerLine;
    }

    public PowerConductor getConductor(int dir) {
        return this.conductor;
    }

    public int getConductorCharge() {
        return (int)(this.conductor.getVoltage() * 10.0);
    }

    public int getConductorFlow() {
        return this.chargeFlow;
    }

    public boolean canConductorWork() {
        return this.getConductorCharge() > 600;
    }
}

