/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.multipart.api.tile.RedstoneConnector;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.part.PneumaticTubePayload;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportMode;
import mrtjp.projectred.expansion.tile.BasePneumaticDeviceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBreakerBlockEntity
extends BasePneumaticDeviceBlockEntity
implements RedstoneConnector {
    private static final GameProfile PR_FAKE_PLAYER = new GameProfile(UUID.fromString("6140461b-e5b4-41ba-beb1-dce616e6abc0"), "[ProjectRed]");

    public BlockBreakerBlockEntity(BlockPos pos, BlockState state) {
        super(ExpansionBlocks.BLOCK_BREAKER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public boolean canConnectTube(int s) {
        return s == this.side;
    }

    @Override
    public boolean canAcceptPayload(int s, PneumaticTubePayload payload, PneumaticTransportMode mode) {
        return s == this.side && mode == PneumaticTransportMode.PASSIVE_BACKSTUFF;
    }

    @Override
    protected void onActivated() {
        BlockPos pos = this.getBlockPos().relative(Direction.values()[this.side ^ 1]);
        BlockState state = this.getLevel().getBlockState(pos);
        if (state.isAir() || state.is(Blocks.BEDROCK)) {
            return;
        }
        if (state.is(this.getBreakingTier().getIncorrectBlocksForDrops())) {
            return;
        }
        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)pos, (BlockEntity)this.getLevel().getBlockEntity(pos));
        this.getLevel().destroyBlock(pos, false);
        for (ItemStack drop : drops) {
            this.itemQueue.add(new PneumaticTubePayload(drop));
        }
        this.exportQueue();
    }

    @Override
    protected void onDeactivated() {
    }

    protected Tier getBreakingTier() {
        return Tiers.IRON;
    }
}

