/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.container.CCLMenuType;
import codechicken.lib.vec.Vector3;
import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.expansion.ProjectRedExpansion;
import mrtjp.projectred.expansion.block.BatteryBoxBlock;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.inventory.container.BatteryBoxMenu;
import mrtjp.projectred.expansion.item.BatteryBoxStorageComponent;
import mrtjp.projectred.expansion.item.IChargable;
import mrtjp.projectred.expansion.item.IRechargableBattery;
import mrtjp.projectred.expansion.tile.LowLoadPoweredBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

public class BatteryBoxBlockEntity
extends LowLoadPoweredBlockEntity {
    private final BatteryBoxInventory inventory = new BatteryBoxInventory();
    private final IItemHandler[] handlers = new IItemHandler[]{new SidedInvWrapper((WorldlyContainer)this.inventory, Direction.DOWN), new SidedInvWrapper((WorldlyContainer)this.inventory, Direction.UP)};
    private int powerStored = 0;

    public BatteryBoxBlockEntity(BlockPos pos, BlockState state) {
        super(ExpansionBlocks.BATTERY_BOX_BLOCK_ENTITY.get(), pos, state);
        this.inventory.addListener(c -> this.setChanged());
    }

    @Override
    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveToNBT(tag, lookupProvider);
        tag.putInt("storage", this.powerStored);
        this.inventory.saveTo(tag, "inventory", lookupProvider);
    }

    @Override
    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadFromNBT(tag, lookupProvider);
        this.powerStored = tag.getInt("storage");
        this.inventory.loadFrom(tag, "inventory", lookupProvider);
    }

    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
    }

    public void readDesc(MCDataInput in) {
        super.readDesc(in);
    }

    public InteractionResult useWithoutItem(Player player, BlockHitResult hit) {
        if (!this.getLevel().isClientSide) {
            CCLMenuType.openMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new BatteryBoxMenu(inv, this, id), (Component)this.getBlockState().getBlock().getName()), p -> p.writePos(this.getBlockPos()));
        }
        return InteractionResult.sidedSuccess((boolean)this.getLevel().isClientSide);
    }

    public void onBlockPlaced(@Nullable LivingEntity player, ItemStack item) {
        super.onBlockPlaced(player, item);
        BatteryBoxStorageComponent component = BatteryBoxStorageComponent.getComponent(item);
        if (component != null) {
            this.powerStored = component.storedPower();
            this.pushBlockState();
        }
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        BatteryBoxBlockEntity.dropInventory((Container)this.inventory, (Level)this.getLevel(), (Vector3)Vector3.fromBlockPos((BlockPos)this.getBlockPos()));
    }

    public ItemStack createStackWithStoredPower() {
        ItemStack stack = new ItemStack((ItemLike)ExpansionBlocks.BATTERY_BOX_BLOCK.get(), 1);
        if (this.powerStored > 0) {
            BatteryBoxStorageComponent component = new BatteryBoxStorageComponent(this.powerStored, this.getPowerStoredScaled(8));
            BatteryBoxStorageComponent.setComponent(stack, component);
        }
        return stack;
    }

    @Override
    public void tick() {
        int newPowerLevel;
        int prevPowerLevel;
        super.tick();
        if (this.getLevel().isClientSide) {
            return;
        }
        boolean changed = false;
        if (this.getConductorCharge() > this.getConductorUpperChargeTarget() && this.powerStored < this.getMaxStorage()) {
            n = Math.min(this.getConductorCharge() - this.getConductorUpperChargeTarget(), this.getConductorChargeSpeed()) / 10;
            n = Math.min(n, this.getMaxStorage() - this.powerStored);
            this.conductor.applyPower((double)(n * -1000));
            this.powerStored += n;
            if (n != 0) {
                changed = true;
            }
        } else if (this.getConductorCharge() < this.getConductorLowerChargeTarget() && this.powerStored > 0) {
            n = Math.min(this.getConductorLowerChargeTarget() - this.getConductorCharge(), this.getConductorChargeSpeed()) / 10;
            n = Math.min(n, this.powerStored);
            this.conductor.applyPower((double)(n * 1000));
            this.powerStored -= n;
            if (n != 0) {
                changed = true;
            }
        }
        changed |= this.tryChargeBattery();
        changed |= this.tryDischargeBattery();
        if (this.powerStored < 0) {
            ProjectRedExpansion.LOGGER.warn("Power stored is negative! BatteryBoxTile @{}", (Object)this.getBlockPos());
            this.powerStored = 0;
        }
        if ((prevPowerLevel = ((Integer)this.getBlockState().getValue((Property)BatteryBoxBlock.CHARGE_LEVEL)).intValue()) != (newPowerLevel = this.getPowerStoredScaled(8))) {
            this.pushBlockState();
        }
        if (changed) {
            this.setChanged();
        }
    }

    public int getMaxStorage() {
        return 8000;
    }

    public int getConductorUpperChargeTarget() {
        return 900;
    }

    public int getConductorLowerChargeTarget() {
        return 800;
    }

    protected int getConductorChargeSpeed() {
        return 100;
    }

    protected int getBatteryChargeSpeed() {
        return 25;
    }

    protected int getPowerStoredScaled(int i) {
        return Math.min(i, i * this.powerStored / this.getMaxStorage());
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)super.storeBlockState(defaultState).setValue((Property)BatteryBoxBlock.CHARGE_LEVEL, (Comparable)Integer.valueOf(this.getPowerStoredScaled(8)));
    }

    private boolean tryChargeBattery() {
        ItemStack stack = this.inventory.getItem(0);
        if (!stack.isEmpty() && stack.getItem() instanceof IChargable) {
            int toAdd = Math.min(this.powerStored, this.getBatteryChargeSpeed());
            Tuple<ItemStack, Integer> result = ((IChargable)stack.getItem()).addPower(stack, toAdd);
            this.inventory.setItem(0, (ItemStack)result.getA());
            this.powerStored -= ((Integer)result.getB()).intValue();
            return (Integer)result.getB() != 0;
        }
        return false;
    }

    private boolean tryDischargeBattery() {
        ItemStack stack = this.inventory.getItem(1);
        if (!stack.isEmpty() && stack.getItem() instanceof IChargable) {
            int toDraw = Math.min(this.getMaxStorage() - this.powerStored, this.getBatteryChargeSpeed());
            Tuple<ItemStack, Integer> result = ((IChargable)stack.getItem()).drawPower(stack, toDraw);
            this.inventory.setItem(1, (ItemStack)result.getA());
            this.powerStored += ((Integer)result.getB()).intValue();
            return (Integer)result.getB() != 0;
        }
        return false;
    }

    public IItemHandler getHandler(Direction side) {
        return this.handlers[side == Direction.UP ? 1 : 0];
    }

    public Container getInventory() {
        return this.inventory;
    }

    public int getPowerStored() {
        return this.powerStored;
    }

    private static class BatteryBoxInventory
    extends BaseContainer
    implements WorldlyContainer {
        private static final int[] TOP_SLOTS = new int[]{0};
        private static final int[] BOTTOM_SLOTS = new int[]{1};

        public BatteryBoxInventory() {
            super(2);
        }

        public int getMaxStackSize() {
            return 1;
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return stack.getItem() instanceof IRechargableBattery;
        }

        public int[] getSlotsForFace(Direction direction) {
            return direction == Direction.UP ? TOP_SLOTS : BOTTOM_SLOTS;
        }

        public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction direction) {
            return true;
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
            return true;
        }
    }
}

