/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.tile.ProjectRedBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BaseDeviceBlockEntity
extends ProjectRedBlockEntity {
    protected int side = 0;
    protected boolean powered = false;
    protected boolean active = false;
    private long schedTick = -1L;

    public BaseDeviceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.side = (Integer)state.getValue((Property)ProjectRedBlock.SIDE);
    }

    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        tag.putLong("schedTick", this.schedTick);
        tag.putByte("side", (byte)this.side);
        tag.putBoolean("powered", this.powered);
        tag.putBoolean("active", this.active);
    }

    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.schedTick = tag.getLong("schedTick");
        this.side = tag.getByte("side");
        this.powered = tag.getBoolean("powered");
        this.active = tag.getBoolean("active");
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public void tick() {
        if (this.getLevel().isClientSide) {
            return;
        }
        if (this.schedTick >= 0L && this.getLevel().getGameTime() >= this.schedTick) {
            this.schedTick = -1L;
            this.onScheduledTick();
            this.setChanged();
        }
    }

    protected void onScheduledTick() {
        if (this.getLevel().isClientSide) {
            return;
        }
        if (!this.powered && !this.shouldStayActive()) {
            this.active = false;
            this.pushBlockState();
            this.onDeactivated();
            this.setChanged();
        }
    }

    protected boolean isTickScheduled() {
        return this.schedTick >= 0L;
    }

    protected void scheduleTick(int ticks) {
        long targetTime = this.getLevel().getGameTime() + (long)ticks;
        if (this.schedTick > 0L && this.schedTick < targetTime) {
            return;
        }
        this.schedTick = targetTime;
        this.setChanged();
    }

    public void onNeighborBlockChanged(BlockPos neighborPos) {
        super.onNeighborBlockChanged(neighborPos);
        if (this.getLevel().isClientSide) {
            return;
        }
        if (this.getLevel().hasNeighborSignal(this.getBlockPos())) {
            if (!this.powered) {
                this.powered = true;
                if (!this.active) {
                    this.active = true;
                    this.pushBlockState();
                    this.onActivated();
                }
                this.setChanged();
            }
        } else {
            if (this.active && !this.isTickScheduled()) {
                this.scheduleTick(4);
            }
            this.powered = false;
            this.setChanged();
        }
    }

    public ItemInteractionResult useItemOn(ItemStack held, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = held.getItem();
        if (item instanceof IScrewdriver) {
            IScrewdriver screwdriver = (IScrewdriver)item;
            if (screwdriver.canUse(player, hand)) {
                if (!this.level.isClientSide) {
                    this.side = (this.side + 1) % 6;
                    screwdriver.damageScrewdriver(player, hand);
                    this.pushBlockState();
                    this.setChanged();
                }
                return ItemInteractionResult.sidedSuccess((boolean)this.level.isClientSide);
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)((BlockState)super.storeBlockState(defaultState).setValue((Property)ProjectRedBlock.SIDE, (Comparable)Integer.valueOf(this.side))).setValue((Property)ProjectRedBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active));
    }

    protected abstract void onActivated();

    protected abstract void onDeactivated();

    protected boolean shouldStayActive() {
        return false;
    }
}

