/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.part;

import codechicken.multipart.api.PartConverter;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.util.MultipartPlaceContext;
import java.util.Collection;
import java.util.Collections;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.part.FramePart;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class FramePartConverter
extends PartConverter {
    public static final FramePartConverter INSTANCE = new FramePartConverter();

    private FramePartConverter() {
    }

    public PartConverter.ConversionResult<Collection<MultiPart>> convert(LevelAccessor world, BlockPos pos, BlockState state) {
        if (state == ExpansionBlocks.FRAME_BLOCK.get().defaultBlockState()) {
            return PartConverter.ConversionResult.success(Collections.singleton(new FramePart()));
        }
        return FramePartConverter.emptyResultList();
    }

    public PartConverter.ConversionResult<MultiPart> convert(MultipartPlaceContext context) {
        BlockState state;
        if (context.getItemInHand().getItem() == ExpansionBlocks.FRAME_BLOCK.get().asItem() && (state = ExpansionBlocks.FRAME_BLOCK.get().getStateForPlacement((BlockPlaceContext)context)) != null && this.canPlace((BlockPlaceContext)context, state)) {
            return PartConverter.ConversionResult.success((Object)((Object)new FramePart()));
        }
        return FramePartConverter.emptyResult();
    }

    private boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.getPlayer();
        CollisionContext collisioncontext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        return state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) && context.getLevel().isUnobstructed(state, context.getClickedPos(), collisioncontext);
    }
}

