/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.block;

import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.api.Frame;
import mrtjp.projectred.expansion.client.FrameModelRenderer;
import mrtjp.projectred.expansion.client.FrameModelVerts;
import mrtjp.projectred.lib.ModelVoxelShape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.loading.FMLEnvironment;

public class FrameBlock
extends Block
implements Frame {
    private static final VoxelShape[] shapes = new VoxelShape[64];

    public FrameBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.0f).sound(SoundType.WOOD).dynamicShape());
    }

    public boolean canGrab(Level w, BlockPos pos, Direction side) {
        return true;
    }

    public boolean canBeGrabbed(Level w, BlockPos pos, Direction side) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return FrameBlock.getOrGenerateShape(0);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getShape(state, level, pos, CollisionContext.empty());
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public static VoxelShape getOrGenerateShape(int mask) {
        VoxelShape s = shapes[mask & 0x3F];
        if (s == null) {
            FrameBlock.shapes[mask & 0x3F] = s = FrameBlock.generateShape(mask);
        }
        return s;
    }

    private static VoxelShape generateShape(int mask) {
        double th = 0.125;
        Cuboid6 e0 = new Cuboid6(0.0, 0.0, 0.0, 1.0, th, th);
        Cuboid6 e1 = e0.copy().apply(Rotation.quarterRotations[1].at(Vector3.CENTER));
        Cuboid6 e2 = e0.copy().apply(Rotation.quarterRotations[2].at(Vector3.CENTER));
        Cuboid6 e3 = e0.copy().apply(Rotation.quarterRotations[3].at(Vector3.CENTER));
        LinkedList<VoxelShape> faceShapes = new LinkedList<VoxelShape>();
        for (int s = 0; s < 6; ++s) {
            Transformation t = Rotation.sideOrientation((int)s, (int)0).at(Vector3.CENTER);
            ImmutableSet.Builder fb = ImmutableSet.builder();
            fb.add((Object)VoxelShapeCache.getShape((Cuboid6)e0.copy().apply(t)));
            fb.add((Object)VoxelShapeCache.getShape((Cuboid6)e2.copy().apply(t)));
            fb.add((Object)VoxelShapeCache.getShape((Cuboid6)e1.copy().apply(t)));
            fb.add((Object)VoxelShapeCache.getShape((Cuboid6)e3.copy().apply(t)));
            faceShapes.add(VoxelShapeCache.merge((ImmutableSet)fb.build()));
        }
        Vertex5[] verts = FMLEnvironment.dist.isClient() ? FrameModelRenderer.getQuadsForMask(mask) : FrameBlock.getQuadsForMask(mask);
        VoxelShape parent = VoxelShapeCache.merge((ImmutableSet)ImmutableSet.copyOf(faceShapes));
        return ModelVoxelShape.fromQuads((VoxelShape)parent, (Vertex5[])verts);
    }

    private static Vertex5[] getQuadsForMask(int mask) {
        LinkedList<Vertex5> verts = new LinkedList<Vertex5>();
        verts.addAll(List.of(FrameModelVerts.verts.get("frame")));
        for (int i = 0; i < 6; ++i) {
            if ((mask & 1 << i) != 0) continue;
            Vertex5[] crossModel = FrameModelVerts.verts.get("cross_" + i);
            verts.addAll(List.of(crossModel));
        }
        return verts.toArray(new Vertex5[0]);
    }
}

