/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.SimpleMultipartType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.item.TubePartItem;
import mrtjp.projectred.expansion.part.BaseTubePart;
import mrtjp.projectred.expansion.part.PneumaticTubePart;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public enum TubeType {
    PNEUMATIC_TUBE("pneumatic_tube", PneumaticTubePart::new, "pneumatic_tube");

    private final String unlocalName;
    private final Function<TubeType, BaseTubePart> partFactory;
    private final List<String> textureNames;
    @Nullable
    private Supplier<Item> itemSupplier;
    @Nullable
    private Supplier<MultipartType<BaseTubePart>> partSupplier;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private List<TextureAtlasSprite> textures;

    private TubeType(String unlocalName, Function<TubeType, BaseTubePart> partFactory, String ... textures) {
        this.unlocalName = unlocalName;
        this.partFactory = partFactory;
        this.textureNames = ImmutableList.copyOf((Object[])textures);
    }

    public String getUnlocalizedName() {
        return this.unlocalName;
    }

    public Item getItem() {
        return Objects.requireNonNull(this.itemSupplier).get();
    }

    public ItemStack makeStack() {
        return new ItemStack((ItemLike)this.getItem());
    }

    public MultipartType<BaseTubePart> getPartType() {
        return Objects.requireNonNull(this.partSupplier).get();
    }

    public Supplier<Item> getItemRegistryObject() {
        return Objects.requireNonNull(this.itemSupplier);
    }

    public BaseTubePart newPart() {
        return this.partFactory.apply(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<TextureAtlasSprite> getTextures() {
        return Objects.requireNonNull(this.textures);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onTextureStitchEvent(TextureAtlasStitchedEvent event) {
        int i;
        if (!event.getAtlas().location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            return;
        }
        if (this.textureNames.isEmpty()) {
            return;
        }
        this.textures = new ArrayList<TextureAtlasSprite>(this.textureNames.size());
        for (i = 0; i < this.textureNames.size(); ++i) {
            this.textures.add(null);
        }
        for (i = 0; i < this.textureNames.size(); ++i) {
            ResourceLocation tex = ResourceLocation.fromNamespaceAndPath((String)"projectred_expansion", (String)("block/" + this.textureNames.get(i)));
            this.textures.set(i, event.getAtlas().getSprite(tex));
        }
    }

    public void registerParts(DeferredRegister<MultipartType<?>> partRegistry, DeferredRegister<Item> itemRegistry) {
        this.itemSupplier = itemRegistry.register(this.unlocalName, () -> new TubePartItem(this));
        this.partSupplier = partRegistry.register(this.unlocalName, () -> new SimpleMultipartType(isClient -> this.partFactory.apply(this)));
    }
}

