/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.function.Function;
import mrtjp.projectred.expansion.ExpansionNetwork;
import mrtjp.projectred.expansion.graphs.ClientSideLinkCache;
import mrtjp.projectred.expansion.graphs.GraphContainer;
import mrtjp.projectred.expansion.part.PneumaticTubePart;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class GraphDebugManager {
    private static final HashMap<ResourceKey<Level>, GraphDebugManager> CLIENT_INSTANCE = new HashMap();
    private static boolean enableRendering = false;
    private final ResourceKey<Level> dimension;
    private final HashSet<GraphContainer> containers = new HashSet();

    public GraphDebugManager(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public static GraphDebugManager getInstance(Level level) {
        return CLIENT_INSTANCE.computeIfAbsent((ResourceKey<Level>)level.dimension(), GraphDebugManager::new);
    }

    private PacketCustom createPacket(int key) {
        return new PacketCustom(ExpansionNetwork.NET_CHANNEL, 2, (RegistryAccess)Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer()).registryAccess()).writeByte(key);
    }

    public void read(MCDataInput input, Level level) {
        short key = input.readUByte();
        switch (key) {
            default: 
        }
        throw new RuntimeException("Unknown key: " + key);
    }

    public void onWorldJoin(GraphContainer container) {
        this.containers.add(container);
    }

    public void onWorldSeparate(GraphContainer container) {
        this.containers.remove(container);
    }

    public static void registerClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"project_red").then(Commands.literal((String)"tube_graph_debug").then(Commands.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            enableRendering = BoolArgumentType.getBool((CommandContext)ctx, (String)"enable");
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Tube graph debugging " + (enableRendering ? "enabled" : "disabled"))), false);
            return 0;
        }))));
    }

    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            GraphDebugManager.getInstance((Level)level).containers.clear();
        }
    }

    public static void onLevelTick(LevelTickEvent.Pre event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!enableRendering) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        GraphDebugManager renderer = GraphDebugManager.getInstance((Level)level);
        HashMap<BlockPos, ClientSideLinkCache> links = new HashMap<BlockPos, ClientSideLinkCache>();
        for (GraphContainer container : renderer.containers) {
            if (!(container instanceof PneumaticTubePart)) continue;
            PneumaticTubePart ptp = (PneumaticTubePart)container;
            if (!ptp.linkCache.isActive()) continue;
            links.put(ptp.pos(), ptp.linkCache);
        }
        if (links.isEmpty()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Vec3 cam = event.getCamera().getPosition();
        PoseStack stack = event.getPoseStack();
        stack.pushPose();
        stack.translate(-cam.x, -cam.y, -cam.z);
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        GraphDebugManager.renderLinks(stack, buffers, links);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderLinks(PoseStack stack, MultiBufferSource.BufferSource buffers, Map<BlockPos, ClientSideLinkCache> links) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(GraphDebugManagerClientRenderTypes.DEBUG_LINES_RENDER_TYPE.apply(2.0), (MultiBufferSource)buffers, stack);
        ccrs.baseColour = EnumColour.ORANGE.rgba();
        for (Map.Entry<BlockPos, ClientSideLinkCache> entry : links.entrySet()) {
            RenderUtils.bufferCuboidOutline((VertexConsumer)ccrs.getConsumer(), (Cuboid6)Cuboid6.full.copy().expand(-0.125).add(entry.getKey()), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        ccrs.bind(GraphDebugManagerClientRenderTypes.DEBUG_LINES_RENDER_TYPE.apply(1.5), (MultiBufferSource)buffers, stack);
        ccrs.baseColour = EnumColour.LIGHT_BLUE.rgba();
        for (Map.Entry<BlockPos, ClientSideLinkCache> entry : links.entrySet()) {
            for (ClientSideLinkCache.ClientLink link : entry.getValue().links) {
                BlockPos segStart;
                LinkedList<Vector3> segmentPoints = link.getPointListFor(segStart = entry.getKey());
                if (segmentPoints.isEmpty()) continue;
                Iterator pointsIt = segmentPoints.iterator();
                Vector3 p1 = (Vector3)pointsIt.next();
                while (pointsIt.hasNext()) {
                    Vector3 p2 = (Vector3)pointsIt.next();
                    GraphDebugManager.bufferLinePair(ccrs.getConsumer(), p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, 1.0f, 1.0f, 1.0f, 1.0f);
                    p1 = p2;
                }
                double s = 4.0;
                RenderUtils.bufferCuboidOutline((VertexConsumer)ccrs.getConsumer(), (Cuboid6)new Cuboid6(-s / 16.0, -s / 16.0, -s / 16.0, s / 16.0, s / 16.0, s / 16.0).add(segmentPoints.getFirst()), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                s = 5.0;
                RenderUtils.bufferCuboidOutline((VertexConsumer)ccrs.getConsumer(), (Cuboid6)new Cuboid6(-s / 16.0, -s / 16.0, -s / 16.0, s / 16.0, s / 16.0, s / 16.0).add(segmentPoints.getLast()), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        ccrs.bind(GraphDebugManagerClientRenderTypes.DEBUG_CUBE_RENDER_TYPE, (MultiBufferSource)buffers, stack);
        ccrs.baseColour = EnumColour.LIGHT_BLUE.rgba(128);
        double b = 0.03125;
        Cuboid6 box = new Cuboid6(-b, -b, -b, b, b, b);
        for (Map.Entry<BlockPos, ClientSideLinkCache> entry : links.entrySet()) {
            for (ClientSideLinkCache.ClientLink link : entry.getValue().links) {
                LinkedList<Vector3> points = link.getPointListFor(entry.getKey());
                for (Vector3 p : points) {
                    ccrs.setPipeline(new IVertexOperation[]{new Translation(p)});
                    BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)box, (int)0);
                }
            }
        }
        buffers.endBatch();
        stack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void bufferLinePair(VertexConsumer builder, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        Vector3 v1 = new Vector3(x1, y1, z1).subtract(x2, y2, z2);
        double d = v1.mag();
        v1.divide(d);
        builder.addVertex((float)x1, (float)y1, (float)z1).setColor(r, g, b, a).setNormal((float)v1.x, (float)v1.y, (float)v1.z);
        builder.addVertex((float)x2, (float)y2, (float)z2).setColor(r, g, b, a).setNormal((float)v1.x, (float)v1.y, (float)v1.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GraphDebugManagerClientRenderTypes {
        @OnlyIn(value=Dist.CLIENT)
        private static RenderType DEBUG_CUBE_RENDER_TYPE = RenderType.create((String)"projectred_expansion:graph_debug_cube", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTextureState(RenderStateShard.NO_TEXTURE).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.NO_LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.NO_LAYERING).setOutputState(RenderStateShard.PARTICLES_TARGET).setTexturingState(RenderStateShard.DEFAULT_TEXTURING).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLineState(RenderStateShard.DEFAULT_LINE).createCompositeState(true));
        @OnlyIn(value=Dist.CLIENT)
        public static Function<Double, RenderType> DEBUG_LINES_RENDER_TYPE = Util.memoize(a -> RenderType.create((String)"projectred_expansion:graph_debug_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setTextureState(RenderStateShard.NO_TEXTURE).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.NO_LIGHTMAP).setOverlayState(RenderStateShard.NO_OVERLAY).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setOutputState(RenderStateShard.PARTICLES_TARGET).setTexturingState(RenderStateShard.DEFAULT_TEXTURING).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(a))).createCompositeState(false)));

        private GraphDebugManagerClientRenderTypes() {
        }
    }
}

