/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.worldgen;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.Nullable;

public final class WorldStripper {
    private static final int BLOCKS_PER_TICK = 4096;
    @Nullable
    private static Worker WORKER;

    private WorldStripper() {
    }

    public static void onServerTick(ServerTickEvent.Post ignoredEvent) {
        if (WORKER == null) {
            return;
        }
        WORKER.doWork();
        if (WORKER.isDone()) {
            WORKER = null;
        }
    }

    public static void stripWorld(ServerPlayer player, ServerLevel level, int radius) {
        BlockPos playerPos = player.blockPosition();
        BlockPos min = new BlockPos(playerPos.getX() - radius, level.getMinBuildHeight(), playerPos.getZ() - radius);
        BlockPos max = new BlockPos(playerPos.getX() + radius, level.getMaxBuildHeight(), playerPos.getZ() + radius);
        Iterator<BlockInWorld> blockIterator = BlockPos.betweenClosedStream((BlockPos)min, (BlockPos)max).map(pos -> WorldStripper.blockInWorld(level, pos)).collect(Collectors.toList()).iterator();
        WORKER = new Worker(level, blockIterator);
    }

    private static BlockInWorld blockInWorld(ServerLevel level, BlockPos pos) {
        return new BlockInWorld((LevelReader)level, pos, true);
    }

    private static final class Worker {
        private final ServerLevel level;
        private final Iterator<BlockInWorld> iterator;
        private final Map<Block, Boolean> removeCache = new IdentityHashMap<Block, Boolean>();

        private Worker(ServerLevel level, Iterator<BlockInWorld> blockIterator) {
            this.level = level;
            this.iterator = blockIterator;
        }

        private void doWork() {
            for (int count = 0; this.iterator.hasNext() && count < 4096; ++count) {
                BlockInWorld block = this.iterator.next();
                this.iterator.remove();
                if (!this.removeCache.computeIfAbsent(block.getState().getBlock(), $ -> this.shouldRemove(block)).booleanValue()) continue;
                this.level.setBlock(block.getPos(), Blocks.AIR.defaultBlockState(), 3);
            }
        }

        private boolean isDone() {
            return !this.iterator.hasNext();
        }

        private boolean shouldRemove(BlockInWorld block) {
            BlockState state = block.getState();
            return !state.isAir() && !state.is(Blocks.BEDROCK) && block.getEntity() == null && !(state.getBlock() instanceof DropExperienceBlock) && !BuiltInRegistries.BLOCK.wrapAsHolder((Object)state.getBlock()).tags().anyMatch(t -> t.location().toString().startsWith("c:ores"));
        }
    }
}

