/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.plugin.AlmostUnifiedNeoPlugin;
import com.almostreliable.unified.api.plugin.AlmostUnifiedPlugin;
import com.almostreliable.unified.compat.PluginManager;
import com.almostreliable.unified.compat.viewer.ClientRecipeTracker;
import com.almostreliable.unified.core.AlmostUnifiedCommands;
import com.almostreliable.unified.core.RecipeLoadCondition;
import com.almostreliable.unified.unification.worldgen.WorldGenBiomeModifier;
import com.almostreliable.unified.unification.worldgen.WorldStripper;
import com.almostreliable.unified.utils.Utils;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

@Mod(value="almostunified")
public class AlmostUnifiedNeoForge {
    public AlmostUnifiedNeoForge(IEventBus eventBus) {
        eventBus.addListener(this::onRegisterEvent);
        eventBus.addListener(this::onCommonSetup);
        NeoForge.EVENT_BUS.addListener(this::onCommandsRegister);
        NeoForge.EVENT_BUS.addListener(WorldStripper::onServerTick);
    }

    private void onRegisterEvent(RegisterEvent event) {
        if (event.getRegistryKey() == NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS) {
            Registry.register((Registry)NeoForgeRegistries.BIOME_MODIFIER_SERIALIZERS, (ResourceLocation)Utils.getRL("worldgen_unification"), WorldGenBiomeModifier.CODEC);
        }
        if (event.getRegistryKey() == NeoForgeRegistries.Keys.CONDITION_CODECS) {
            Registry.register((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (String)RecipeLoadCondition.ID, RecipeLoadCondition.CODEC);
        }
        if (AlmostUnifiedCommon.STARTUP_CONFIG.isServerOnly()) {
            return;
        }
        if (event.getRegistryKey() == Registries.RECIPE_SERIALIZER) {
            Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)ClientRecipeTracker.ID, ClientRecipeTracker.SERIALIZER);
        }
        if (event.getRegistryKey() == Registries.RECIPE_TYPE) {
            Registry.register((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)ClientRecipeTracker.ID, ClientRecipeTracker.TYPE);
        }
    }

    private void onCommandsRegister(RegisterCommandsEvent event) {
        AlmostUnifiedCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(AlmostUnifiedNeoForge::initializePluginManager);
    }

    private static void initializePluginManager() {
        ArrayList<AlmostUnifiedPlugin> plugins = new ArrayList<AlmostUnifiedPlugin>();
        Collection<Class<AlmostUnifiedPlugin>> pluginClasses = AlmostUnifiedNeoForge.getPluginClasses();
        for (Class<AlmostUnifiedPlugin> pluginClass : pluginClasses) {
            try {
                plugins.add(pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                AlmostUnifiedCommon.LOGGER.error("Failed to load plugin {}.", (Object)pluginClass.getName(), (Object)e);
            }
        }
        PluginManager.init(plugins);
    }

    private static Collection<Class<AlmostUnifiedPlugin>> getPluginClasses() {
        HashSet<Class<AlmostUnifiedPlugin>> pluginClasses = new HashSet<Class<AlmostUnifiedPlugin>>();
        Type type = Type.getType(AlmostUnifiedNeoPlugin.class);
        for (ModFileScanData data : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData annotation : data.getAnnotations()) {
                Class<AlmostUnifiedPlugin> plugin;
                if (!annotation.annotationType().equals((Object)type) || (plugin = AlmostUnifiedNeoForge.getPluginClass(annotation.clazz().getClassName())) == null) continue;
                pluginClasses.add(plugin);
            }
        }
        return pluginClasses;
    }

    @Nullable
    private static Class<AlmostUnifiedPlugin> getPluginClass(String className) {
        try {
            Class<AlmostUnifiedPlugin> pluginClass = Class.forName(className);
            if (AlmostUnifiedPlugin.class.isAssignableFrom(pluginClass)) {
                return pluginClass;
            }
            AlmostUnifiedCommon.LOGGER.error("Plugin {} does not implement {}.", (Object)className, (Object)AlmostUnifiedPlugin.class.getName());
        }
        catch (ClassNotFoundException e) {
            AlmostUnifiedCommon.LOGGER.error("Failed to load plugin {}.", (Object)className, (Object)e);
            return null;
        }
        return null;
    }
}

