/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.util;

import com.mojang.logging.LogUtils;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.neoforge.NeoForgeAdapter;
import com.sk89q.worldedit.neoforge.NeoForgePlayer;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class WorldEditUtils {
    public static void selectArea(ServerPlayer player, BlockPos corner1, BlockPos corner2) {
        NeoForgePlayer worldEditPlayer = NeoForgeAdapter.adaptPlayer((ServerPlayer)player);
        LocalSession worldEdit = WorldEdit.getInstance().getSessionManager().get((SessionOwner)worldEditPlayer);
        BlockVector3 selection1 = BlockVector3.at((int)corner1.getX(), (int)corner1.getY(), (int)corner1.getZ());
        BlockVector3 selection2 = BlockVector3.at((int)corner2.getX(), (int)corner2.getY(), (int)corner2.getZ());
        worldEdit.getRegionSelector(NeoForgeAdapter.adapt((ServerLevel)player.serverLevel())).selectPrimary(selection1, null);
        worldEdit.getRegionSelector(NeoForgeAdapter.adapt((ServerLevel)player.serverLevel())).selectSecondary(selection2, null);
        worldEdit.dispatchCUISelection((Actor)worldEditPlayer);
    }

    public static Region getArea(ServerPlayer player) {
        NeoForgePlayer worldEditPlayer = NeoForgeAdapter.adaptPlayer((ServerPlayer)player);
        LocalSession worldEdit = WorldEdit.getInstance().getSessionManager().get((SessionOwner)worldEditPlayer);
        try {
            return worldEdit.getSelection(worldEditPlayer.getWorld());
        }
        catch (IncompleteRegionException e) {
            LogUtils.getLogger().error("Region is incomplete");
            return null;
        }
    }
}

