/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class PermissionManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final LevelResource WORLD_FOLDER = new LevelResource("arkanis-lunazstudios");
    private static PermissionManager instance;
    private final Set<UUID> allowedPlayers = new HashSet<UUID>();

    private PermissionManager() {
    }

    public static PermissionManager getInstance() {
        if (instance == null) {
            instance = new PermissionManager();
        }
        return instance;
    }

    public void addPlayer(UUID uuid) {
        this.allowedPlayers.add(uuid);
    }

    public void removePlayer(UUID uuid) {
        this.allowedPlayers.remove(uuid);
    }

    public boolean isPlayerAllowed(UUID uuid) {
        return this.allowedPlayers.contains(uuid);
    }

    public void savePermissions(MinecraftServer server) {
        File permissionFile = PermissionManager.getPermissionFile(server);
        if (!permissionFile.getParentFile().exists()) {
            permissionFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(permissionFile);){
            GSON.toJson(this.allowedPlayers, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadPermissions(MinecraftServer server) {
        File permissionFile = PermissionManager.getPermissionFile(server);
        if (permissionFile.exists()) {
            try (FileReader reader = new FileReader(permissionFile);){
                Type setType = new TypeToken<HashSet<UUID>>(this){}.getType();
                Set loadedPermissions = (Set)GSON.fromJson((Reader)reader, setType);
                if (loadedPermissions != null) {
                    this.allowedPlayers.addAll(loadedPermissions);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static File getPermissionFile(MinecraftServer server) {
        Path worldDir = server.getWorldPath(WORLD_FOLDER);
        return new File(worldDir.toFile(), "arkanis-permissions.json");
    }

    public Set<UUID> getAllowedPlayers() {
        return this.allowedPlayers;
    }
}

