/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pedrorok.arkanisward.data.Area;
import com.pedrorok.arkanisward.data.Flag;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class AreaManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Area.class, (Object)new AreaSerializer()).registerTypeAdapter(Area.class, (Object)new AreaDeserializer()).create();
    private static final LevelResource WORLD_FOLDER = new LevelResource("arkanis-lunazstudios");
    private static AreaManager instance;
    private final List<Area> areas = new ArrayList<Area>();

    private AreaManager() {
    }

    public static AreaManager getInstance() {
        if (instance == null) {
            instance = new AreaManager();
        }
        return instance;
    }

    public void addArea(String name, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.areas.add(new Area(name, x1, y1, z1, x2, y2, z2));
    }

    public boolean exists(String name) {
        for (Area area : this.areas) {
            if (!area.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void removeArea(String name) {
        this.areas.removeIf(area -> area.getName().equals(name));
    }

    public List<Area> getAreas() {
        return this.areas;
    }

    public void setFlag(String name, Flag flag, boolean value) {
        for (Area area : this.areas) {
            if (!area.getName().equals(name)) continue;
            area.setFlag(flag, value);
            break;
        }
    }

    public void removeFlag(String name, Flag flag) {
        for (Area area : this.areas) {
            if (!area.getName().equals(name)) continue;
            area.removeFlag(flag);
            break;
        }
    }

    public boolean isCoordinateInArea(int x, int y, int z) {
        for (Area area : this.areas) {
            if (!this.isWithinBounds(area.getX1(), area.getX2(), x) || !this.isWithinBounds(area.getY1(), area.getY2(), y) || !this.isWithinBounds(area.getZ1(), area.getZ2(), z)) continue;
            return true;
        }
        return false;
    }

    public void editArea(String name, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (Area area : this.areas) {
            if (!area.getName().equals(name)) continue;
            ArrayList<Flag> flags = new ArrayList<Flag>(area.getFlags().keySet());
            this.areas.remove(area);
            Area newArea = new Area(name, x1, y1, z1, x2, y2, z2);
            for (Flag flag : flags) {
                newArea.setFlag(flag, area.getFlags().get((Object)flag));
            }
            this.areas.add(newArea);
            break;
        }
    }

    public boolean isFlagSetAtCoordinate(int x, int y, int z, Flag flag) {
        for (Area area : this.areas) {
            if (!this.isWithinBounds(area.getX1(), area.getX2(), x) || !this.isWithinBounds(area.getY1(), area.getY2(), y) || !this.isWithinBounds(area.getZ1(), area.getZ2(), z)) continue;
            return area.getFlags().getOrDefault((Object)flag, true);
        }
        return false;
    }

    private boolean isWithinBounds(int coord1, int coord2, int value) {
        return value >= Math.min(coord1, coord2) && value <= Math.max(coord1, coord2);
    }

    public void saveAreas(MinecraftServer server) {
        File areaFile = AreaManager.getAreaFile(server);
        if (!areaFile.getParentFile().exists()) {
            areaFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(areaFile);){
            GSON.toJson(this.areas, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadAreas(MinecraftServer server) {
        File areaFile = AreaManager.getAreaFile(server);
        if (areaFile.exists()) {
            try (FileReader reader = new FileReader(areaFile);){
                Area[] loadedAreas = (Area[])GSON.fromJson((Reader)reader, Area[].class);
                if (loadedAreas != null) {
                    for (Area area : loadedAreas) {
                        this.areas.add(area);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Area getAreaByName(String name) {
        for (Area area : this.areas) {
            if (!area.getName().equals(name)) continue;
            return area;
        }
        return null;
    }

    private static File getAreaFile(MinecraftServer server) {
        Path worldDir = server.getWorldPath(WORLD_FOLDER);
        return new File(worldDir.toFile(), "arkanisward-areas.json");
    }

    private static class AreaSerializer
    implements JsonSerializer<Area> {
        private AreaSerializer() {
        }

        public JsonElement serialize(Area src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", src.getName());
            obj.addProperty("x1", (Number)src.getX1());
            obj.addProperty("y1", (Number)src.getY1());
            obj.addProperty("z1", (Number)src.getZ1());
            obj.addProperty("x2", (Number)src.getX2());
            obj.addProperty("y2", (Number)src.getY2());
            obj.addProperty("z2", (Number)src.getZ2());
            JsonObject flags = new JsonObject();
            for (Map.Entry<Flag, Boolean> entry : src.getFlags().entrySet()) {
                flags.addProperty(entry.getKey().name(), entry.getValue());
            }
            obj.add("flags", (JsonElement)flags);
            return obj;
        }
    }

    private static class AreaDeserializer
    implements JsonDeserializer<Area> {
        private AreaDeserializer() {
        }

        public Area deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            String name = obj.get("name").getAsString();
            int x1 = obj.get("x1").getAsInt();
            int y1 = obj.get("y1").getAsInt();
            int z1 = obj.get("z1").getAsInt();
            int x2 = obj.get("x2").getAsInt();
            int y2 = obj.get("y2").getAsInt();
            int z2 = obj.get("z2").getAsInt();
            Area area = new Area(name, x1, y1, z1, x2, y2, z2);
            JsonObject flags = obj.getAsJsonObject("flags");
            for (Map.Entry entry : flags.entrySet()) {
                area.setFlag(Flag.valueOf((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean());
            }
            return area;
        }
    }
}

