/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.mixin;

import com.pedrorok.arkanisward.data.Flag;
import com.pedrorok.arkanisward.util.AreaManager;
import com.simibubi.create.content.kinetics.drill.DrillMovementBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DrillMovementBehaviour.class})
public abstract class DrillMovementBehaviourMixin {
    @Inject(method={"canBreak"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    protected void onMovementAllowed(Level world, BlockPos breakingPos, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        AreaManager areaManager = AreaManager.getInstance();
        if (!areaManager.isCoordinateInArea(breakingPos.getX(), breakingPos.getY(), breakingPos.getZ())) {
            return;
        }
        if (!areaManager.isFlagSetAtCoordinate(breakingPos.getX(), breakingPos.getY(), breakingPos.getZ(), Flag.CAN_DRILLS_BREAK)) {
            cir.setReturnValue((Object)false);
        }
    }
}

