/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.mixin;

import com.pedrorok.arkanisward.data.Flag;
import com.pedrorok.arkanisward.util.AreaManager;
import com.simibubi.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import net.minecraft.core.BlockPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockBreakingKineticBlockEntity.class})
public abstract class BlockBreakingKineticBlockEntityMixin {
    @Shadow
    protected abstract BlockPos getBreakingPos();

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onTick(CallbackInfo ci) {
        BlockBreakingKineticBlockEntity self = (BlockBreakingKineticBlockEntity)this;
        BlockPos breakingPos = this.getBreakingPos();
        if (breakingPos == null) {
            return;
        }
        AreaManager areaManager = AreaManager.getInstance();
        if (!areaManager.isCoordinateInArea(breakingPos.getX(), breakingPos.getY(), breakingPos.getZ())) {
            return;
        }
        if (!areaManager.isFlagSetAtCoordinate(breakingPos.getX(), breakingPos.getY(), breakingPos.getZ(), Flag.CAN_DRILLS_BREAK)) {
            ci.cancel();
        }
    }
}

