/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.event;

import com.pedrorok.arkanisward.data.Flag;
import com.pedrorok.arkanisward.util.AreaManager;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ExplosionEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="arkanisward")
public class ExplosionEvents {
    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        AreaManager areaManager = AreaManager.getInstance();
        event.getAffectedBlocks().removeIf(pos -> {
            if (areaManager.isCoordinateInArea(pos.getX(), pos.getY(), pos.getZ())) {
                return !areaManager.isFlagSetAtCoordinate(pos.getX(), pos.getY(), pos.getZ(), Flag.CAN_BE_EXPLODED);
            }
            return false;
        });
        event.getAffectedEntities().removeIf(entity -> {
            if (areaManager.isCoordinateInArea((int)entity.getX(), (int)entity.getY(), (int)entity.getZ())) {
                return !areaManager.isFlagSetAtCoordinate((int)entity.getX(), (int)entity.getY(), (int)entity.getZ(), Flag.CAN_EXPLODE_ENTITIES);
            }
            return false;
        });
    }
}

