/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.event;

import com.pedrorok.arkanisward.data.Flag;
import com.pedrorok.arkanisward.util.AreaManager;
import com.pedrorok.arkanisward.util.PermissionManager;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="arkanisward")
public class EntityEvents {
    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void onItemFrameAttack(AttackEntityEvent event) {
        AreaManager areaManager = AreaManager.getInstance();
        boolean isCoordinateInArea = areaManager.isCoordinateInArea((int)event.getTarget().getX(), (int)event.getTarget().getY(), (int)event.getTarget().getZ());
        boolean isFlagSet = areaManager.isFlagSetAtCoordinate((int)event.getTarget().getX(), (int)event.getTarget().getY(), (int)event.getTarget().getZ(), Flag.CAN_BREAK_FRAMES_AND_STANDS);
        PermissionManager permissionManager = PermissionManager.getInstance();
        if (event.getTarget() instanceof ItemFrame && isCoordinateInArea && !isFlagSet && !permissionManager.isPlayerAllowed(event.getEntity().getUUID())) {
            event.setCanceled(true);
            event.getEntity().displayClientMessage((Component)Component.literal((String)"Esta \u00e1rea n\u00e3o te permite quebrar em Item Frames."), true);
        }
        if (!(event.getTarget() instanceof ArmorStand)) {
            return;
        }
        if (!isCoordinateInArea) {
            return;
        }
        if (isFlagSet) {
            return;
        }
        if (permissionManager.isPlayerAllowed(event.getEntity().getUUID())) {
            return;
        }
        event.setCanceled(true);
        event.getEntity().displayClientMessage((Component)Component.literal((String)"Esta \u00e1rea n\u00e3o te permite quebrar Armor Stands."), true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        AreaManager areaManager = AreaManager.getInstance();
        PermissionManager permissionManager = PermissionManager.getInstance();
        Player player = event.getEntity();
        if (event.getTarget() instanceof Player) {
            return;
        }
        boolean isCoordinateInArea = areaManager.isCoordinateInArea((int)event.getTarget().getX(), (int)event.getTarget().getY(), (int)event.getTarget().getZ());
        boolean isFlagSet = areaManager.isFlagSetAtCoordinate((int)event.getTarget().getX(), (int)event.getTarget().getY(), (int)event.getTarget().getZ(), Flag.CAN_INTERACT_WITH_ENTITIES);
        if (!isCoordinateInArea) {
            return;
        }
        if (isFlagSet) {
            return;
        }
        if (permissionManager.isPlayerAllowed(player.getUUID())) {
            return;
        }
        event.setCanceled(true);
        player.displayClientMessage((Component)Component.literal((String)"Esta \u00e1rea n\u00e3o te permite interagir com entidades."), true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void onSpawn(EntityJoinLevelEvent event) {
        AreaManager areaManager = AreaManager.getInstance();
        if (event.getEntity() instanceof ServerPlayer) {
            return;
        }
        if (event.getEntity() instanceof ArmorStand) {
            return;
        }
        if (event.getEntity() instanceof Npc) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        boolean isCoordinateInArea = areaManager.isCoordinateInArea((int)entity2.getX(), (int)entity2.getY(), (int)entity2.getZ());
        boolean isFlagSet = areaManager.isFlagSetAtCoordinate((int)entity2.getX(), (int)entity2.getY(), (int)entity2.getZ(), Flag.CAN_MOB_SPAWN);
        if (!isCoordinateInArea) {
            return;
        }
        if (isFlagSet) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void onPvP(AttackEntityEvent event) {
        if (!(event.getTarget() instanceof ServerPlayer)) {
            return;
        }
        AreaManager areaManager = AreaManager.getInstance();
        PermissionManager permissionManager = PermissionManager.getInstance();
        boolean isCoordinateInArea = areaManager.isCoordinateInArea((int)event.getTarget().getX(), (int)event.getTarget().getY(), (int)event.getTarget().getZ());
        boolean isFlagSet = areaManager.isFlagSetAtCoordinate((int)event.getTarget().getX(), (int)event.getTarget().getY(), (int)event.getTarget().getZ(), Flag.CAN_PVP);
        if (!isCoordinateInArea) {
            return;
        }
        if (isFlagSet) {
            return;
        }
        if (permissionManager.isPlayerAllowed(event.getEntity().getUUID())) {
            return;
        }
        event.setCanceled(true);
        event.getEntity().displayClientMessage((Component)Component.literal((String)"Esta \u00e1rea n\u00e3o te permite bater em outros players."), true);
    }
}

