/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.event;

import com.pedrorok.arkanisward.data.Flag;
import com.pedrorok.arkanisward.util.AreaManager;
import com.pedrorok.arkanisward.util.PermissionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="arkanisward")
public class BlockEvents {
    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos clickedPos = event.getPos();
        ItemStack heldItem = event.getItemStack();
        AreaManager areaManager = AreaManager.getInstance();
        PermissionManager permissionManager = PermissionManager.getInstance();
        BlockPos placedBlockPos = clickedPos.relative(event.getFace());
        BlockEntity blockEntity = event.getLevel().getBlockEntity(clickedPos);
        Flag requiredFlag = heldItem.getItem() instanceof BlockItem ? Flag.CAN_PLACE : Flag.CAN_INTERACT;
        boolean isCoordinateNotInArea = !areaManager.isCoordinateInArea(placedBlockPos.getX(), placedBlockPos.getY(), placedBlockPos.getZ());
        boolean isFlagNotSet = !areaManager.isFlagSetAtCoordinate(placedBlockPos.getX(), placedBlockPos.getY(), placedBlockPos.getZ(), requiredFlag);
        boolean isPlayerNotAllowed = !permissionManager.isPlayerAllowed(event.getEntity().getUUID());
        boolean isContainer = blockEntity instanceof BaseContainerBlockEntity;
        if (isCoordinateNotInArea) {
            return;
        }
        if (isFlagNotSet && isPlayerNotAllowed && !isContainer) {
            String message = requiredFlag == Flag.CAN_PLACE ? "Esta \u00e1rea n\u00e3o te permite colocar blocos." : "Esta \u00e1rea n\u00e3o te permite interagir com blocos.";
            event.setCanceled(true);
            event.getEntity().displayClientMessage((Component)Component.literal((String)message), true);
            return;
        }
        if (!isContainer) {
            return;
        }
        if (areaManager.isFlagSetAtCoordinate(clickedPos.getX(), clickedPos.getY(), clickedPos.getZ(), Flag.CAN_OPEN_CHESTS_AND_BARRELS)) {
            return;
        }
        if (permissionManager.isPlayerAllowed(event.getEntity().getUUID())) {
            return;
        }
        event.setCanceled(true);
        event.getEntity().displayClientMessage((Component)Component.literal((String)"Esta \u00e1rea n\u00e3o te permite abrir ba\u00fas ou barris."), true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockPos pos = event.getPos();
        AreaManager areaManager = AreaManager.getInstance();
        PermissionManager permissionManager = PermissionManager.getInstance();
        if (!areaManager.isCoordinateInArea(pos.getX(), pos.getY(), pos.getZ())) {
            return;
        }
        if (areaManager.isFlagSetAtCoordinate(pos.getX(), pos.getY(), pos.getZ(), Flag.CAN_BREAK)) {
            return;
        }
        if (event.getPlayer() instanceof FakePlayer) {
            event.setCanceled(true);
            return;
        }
        if (permissionManager.isPlayerAllowed(event.getPlayer().getUUID())) {
            return;
        }
        event.setCanceled(true);
        event.getPlayer().displayClientMessage((Component)Component.literal((String)"Esta \u00e1rea n\u00e3o te permite quebrar blocos."), true);
    }
}

