/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.pedrorok.arkanisward.data.Area;
import com.pedrorok.arkanisward.data.Flag;
import com.pedrorok.arkanisward.util.AreaManager;
import com.pedrorok.arkanisward.util.WorldEditUtils;
import com.sk89q.worldedit.regions.Region;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class SetAreaCommand {
    private static final AreaManager areaManager = AreaManager.getInstance();

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"arkanis").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"area").requires(cs -> cs.hasPermission(4))).then(((LiteralArgumentBuilder)Commands.literal((String)"create").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"corner1", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"corner2", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> SetAreaCommand.createArea((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BlockPosArgument.getBlockPos((CommandContext)ctx, (String)"corner1"), BlockPosArgument.getBlockPos((CommandContext)ctx, (String)"corner2"))))))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> SetAreaCommand.createAreaWorldEdit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> SetAreaCommand.removeArea((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> SetAreaCommand.listAreas((CommandSourceStack)ctx.getSource()))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> SetAreaCommand.listAreasByPage((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(Commands.literal((String)"setflag").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> SetAreaCommand.listFlags((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"toggleflag").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"flag", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> SetAreaCommand.toggleFlag((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"flag"), BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))))))).then(Commands.literal((String)"removeflag").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"flag", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (Flag flag : Flag.values()) {
                builder.suggest(flag.name());
            }
            return builder.buildFuture();
        }).executes(ctx -> SetAreaCommand.removeFlag((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"flag"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"change").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"corner1", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"corner2", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> SetAreaCommand.changeArea((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BlockPosArgument.getBlockPos((CommandContext)ctx, (String)"corner1"), BlockPosArgument.getBlockPos((CommandContext)ctx, (String)"corner2"))))))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> SetAreaCommand.changeAreaWithWorldEdit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"show").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> SetAreaCommand.showArea((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))));
        dispatcher.register(command);
    }

    private static int changeAreaWithWorldEdit(CommandSourceStack source, String name) {
        Region region = WorldEditUtils.getArea(source.getPlayer());
        if (region == null) {
            source.sendFailure((Component)Component.literal((String)"Nenhuma regi\u00e3o foi selecionada."));
            return 0;
        }
        BlockPos corner1 = new BlockPos(region.getMinimumPoint().getX(), region.getMinimumPoint().getY(), region.getMinimumPoint().getZ());
        BlockPos corner2 = new BlockPos(region.getMaximumPoint().getX(), region.getMaximumPoint().getY(), region.getMaximumPoint().getZ());
        return SetAreaCommand.changeArea(source, name, corner1, corner2);
    }

    private static int changeArea(CommandSourceStack source, String name, BlockPos corner1, BlockPos corner2) {
        if (!(source.getEntity() instanceof ServerPlayer)) {
            return 0;
        }
        if (!areaManager.exists(name)) {
            source.sendFailure((Component)Component.literal((String)("Uma \u00e1rea com o nome '" + name + "' n\u00e3o existe.")));
            return 0;
        }
        areaManager.editArea(name, corner1.getX(), corner1.getY(), corner1.getZ(), corner2.getX(), corner2.getY(), corner2.getZ());
        return 1;
    }

    private static int createArea(CommandSourceStack source, String name, BlockPos corner1, BlockPos corner2) {
        if (!(source.getEntity() instanceof ServerPlayer)) {
            return 0;
        }
        if (areaManager.exists(name)) {
            source.sendFailure((Component)Component.literal((String)("Uma \u00e1rea com o nome '" + name + "' j\u00e1 existe.")));
            return 0;
        }
        areaManager.addArea(name, corner1.getX(), corner1.getY(), corner1.getZ(), corner2.getX(), corner2.getY(), corner2.getZ());
        areaManager.saveAreas(source.getServer());
        source.sendSuccess(() -> Component.literal((String)("\u00c1rea '" + name + "' criada com sucesso.")), true);
        return 1;
    }

    private static int createAreaWorldEdit(CommandSourceStack source, String name) {
        Region region = WorldEditUtils.getArea(source.getPlayer());
        if (region == null) {
            source.sendFailure((Component)Component.literal((String)"Nenhuma regi\u00e3o foi selecionada."));
            return 0;
        }
        BlockPos corner1 = new BlockPos(region.getMinimumPoint().getX(), region.getMinimumPoint().getY(), region.getMinimumPoint().getZ());
        BlockPos corner2 = new BlockPos(region.getMaximumPoint().getX(), region.getMaximumPoint().getY(), region.getMaximumPoint().getZ());
        return SetAreaCommand.createArea(source, name, corner1, corner2);
    }

    private static int removeArea(CommandSourceStack source, String name) {
        if (!areaManager.exists(name)) {
            source.sendFailure((Component)Component.literal((String)("A \u00e1rea '" + name + "' n\u00e3o existe.")));
            return 0;
        }
        areaManager.removeArea(name);
        areaManager.saveAreas(source.getServer());
        source.sendSuccess(() -> Component.literal((String)("Area '" + name + "' removida com sucesso.")), true);
        return 1;
    }

    private static int listAreas(CommandSourceStack source) {
        return SetAreaCommand.listAreasByPage(source, 1);
    }

    private static int listAreasByPage(CommandSourceStack source, int page) {
        int pageSize = 6;
        List<Area> areas = areaManager.getAreas();
        if (areas.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"Sem \u00e1reas definidas."), false);
            return 1;
        }
        int totalPages = (int)Math.ceil((double)areas.size() / (double)pageSize);
        if (page < 1 || page > totalPages) {
            source.sendFailure((Component)Component.literal((String)("P\u00e1gina inv\u00e1lida, use um n\u00famero entre 1 e " + totalPages + ".")));
            return 0;
        }
        source.sendSystemMessage((Component)Component.literal((String)("\u00c1reas definidas (P\u00e1gina " + page + " de " + totalPages + "):")));
        int start = (page - 1) * pageSize;
        int end = Math.min(start + pageSize, areas.size());
        for (int i = start; i < end; ++i) {
            Area area = areas.get(i);
            MutableComponent component = Component.empty();
            component.append((Component)Component.literal((String)("|----------\u00a7d[" + area.getName() + "]\u00a7r----------|\n")));
            component.append((Component)Component.literal((String)"\u00a74[REMOVER]\u00a7r ").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/arkanis area remove " + area.getName()))));
            component.append((Component)Component.literal((String)"\u00a76[EDITAR FLAG]\u00a7r ").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/arkanis area setflag " + area.getName()))));
            component.append((Component)Component.literal((String)"\u00a75[TELEPORTAR]\u00a7r ").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + area.getX1() + " " + area.getY1() + " " + area.getZ1()))));
            component.append((Component)Component.literal((String)"\u00a73[EXIBIR]\u00a7r ").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/arkanis area show " + area.getName()))));
            component.append((Component)Component.literal((String)"\n"));
            source.sendSuccess(() -> component, false);
        }
        MutableComponent pagination = Component.literal((String)"");
        if (page > 1) {
            pagination.append((Component)Component.literal((String)"\u00a7a[Anterior]\u00a7r ").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/arkanis area list " + (page - 1)))));
        } else {
            pagination.append((Component)Component.literal((String)"\u00a77[Anterior]\u00a7r "));
        }
        if (page < totalPages) {
            pagination.append((Component)Component.literal((String)"\u00a7a[Pr\u00f3ximo]\u00a7r").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/arkanis area list " + (page + 1)))));
        } else {
            pagination.append((Component)Component.literal((String)"\u00a77[Pr\u00f3ximo]\u00a7r"));
        }
        if (!pagination.getString().isEmpty()) {
            source.sendSuccess(() -> pagination, false);
        }
        return 1;
    }

    private static int listFlags(CommandSourceStack source, String areaName) {
        Area area = areaManager.getAreaByName(areaName);
        if (area == null) {
            source.sendFailure((Component)Component.literal((String)("A \u00e1rea '" + areaName + "' n\u00e3o existe.")));
            return 0;
        }
        source.sendSuccess(() -> Component.literal((String)"================================================").withStyle(ChatFormatting.GRAY), false);
        source.sendSuccess(() -> Component.literal((String)("Flags da \u00e1rea '" + areaName + "':")), false);
        for (Flag flag : Flag.values()) {
            Boolean value = area.getFlags().get((Object)flag);
            MutableComponent trueText = Component.literal((String)" \u2022 [true]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/arkanis area toggleflag " + areaName + " " + flag.name() + " true")).withColor(Boolean.TRUE.equals(value) ? 0x55FF55 : 0xAAAAAA));
            MutableComponent falseText = Component.literal((String)"[false]").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/arkanis area toggleflag " + areaName + " " + flag.name() + " false")).withColor(Boolean.FALSE.equals(value) ? 0xFF5555 : 0xAAAAAA));
            source.sendSuccess(() -> SetAreaCommand.lambda$listFlags$28((Component)trueText, (Component)falseText, flag), false);
        }
        MutableComponent listAreasComponent = Component.literal((String)"\u00a73[Listar \u00e1reas]\u00a7r ");
        listAreasComponent.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/arkanis area list")));
        source.sendSystemMessage((Component)listAreasComponent);
        source.sendSystemMessage((Component)Component.literal((String)"================================================").withStyle(ChatFormatting.GRAY));
        return 1;
    }

    private static int showArea(CommandSourceStack source, String areaName) {
        if (source.getPlayer() == null) {
            return 0;
        }
        AreaManager areaManager = AreaManager.getInstance();
        Area area = areaManager.getAreaByName(areaName);
        if (area == null) {
            source.sendFailure((Component)Component.literal((String)("A \u00e1rea '" + areaName + "' n\u00e3o existe.")));
            return 0;
        }
        BlockPos corner1 = new BlockPos(area.getX1(), area.getY1(), area.getZ1());
        BlockPos corner2 = new BlockPos(area.getX2(), area.getY2(), area.getZ2());
        ServerPlayer player = source.getPlayer();
        WorldEditUtils.selectArea(player, corner1, corner2);
        Vec3 vec3 = new Vec3((double)area.getX1(), (double)area.getY2(), (double)area.getZ2());
        if (player.position().distanceTo(vec3) > 100.0) {
            source.sendSystemMessage((Component)Component.literal((String)"A \u00e1rea est\u00e1 distante, talvez voc\u00ea n\u00e3o consiga ver a sele\u00e7\u00e3o."));
        }
        return 1;
    }

    private static int toggleFlag(CommandSourceStack source, String areaName, String flagName, boolean value) {
        try {
            Flag flag = Flag.valueOf(flagName.toUpperCase());
            areaManager.setFlag(areaName, flag, value);
            areaManager.saveAreas(source.getServer());
            return SetAreaCommand.listFlags(source, areaName);
        }
        catch (IllegalArgumentException e) {
            source.sendFailure((Component)Component.literal((String)("Nome da flag inv\u00e1lida: " + flagName)));
            return 0;
        }
    }

    private static int removeFlag(CommandSourceStack source, String name, String flagName) {
        try {
            Flag flag = Flag.valueOf(flagName.toUpperCase());
            areaManager.removeFlag(name, flag);
            areaManager.saveAreas(source.getServer());
            source.sendSuccess(() -> Component.literal((String)("Flag '" + flagName + "' removida da \u00e1rea '" + name + "'.")), true);
            return 1;
        }
        catch (IllegalArgumentException e) {
            source.sendFailure((Component)Component.literal((String)("Nome da flag inv\u00e1lida: " + flagName)));
            return 0;
        }
    }

    private static /* synthetic */ Component lambda$listFlags$28(Component trueText, Component falseText, Flag flag) {
        return Component.literal((String)"").append(trueText).append(" / ").append(falseText).append(" ").append((Component)Component.literal((String)flag.name()));
    }
}

