/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pedrorok.arkanisward.util.PermissionManager;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class PermissionCommand {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"arkanis").then(Commands.literal((String)"area").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"perms").requires(cs -> cs.hasPermission(4))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(PermissionCommand::setPlayerPermissionByPlayer))).then(Commands.argument((String)"UUID", (ArgumentType)UuidArgument.uuid()).executes(PermissionCommand::setPlayerPermissionByUUID)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(PermissionCommand::removePlayerPermission)))).then(Commands.literal((String)"list").executes(PermissionCommand::listPermissions))));
        dispatcher.register(command);
    }

    private static int listPermissions(CommandContext<CommandSourceStack> context) {
        PermissionManager permissionManager = PermissionManager.getInstance();
        PlayerList playerList = ((CommandSourceStack)context.getSource()).getServer().getPlayerList();
        if (permissionManager.getAllowedPlayers().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"N\u00e3o h\u00e1 players com permiss\u00f5es."));
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Players com permiss\u00f5es de interagir com \u00e1reas protegidas:"), false);
            for (UUID uuid : permissionManager.getAllowedPlayers()) {
                ServerPlayer player = playerList.getPlayer(uuid);
                String playerName = player != null ? player.getName().getString() : uuid.toString();
                MutableComponent component = Component.literal((String)"\u00a74[REMOVE]\u00a7r").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/arkanis area perms remove " + playerName)));
                component.append((Component)Component.literal((String)(" - " + playerName)));
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> component, false);
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"|-------------------------------------------------|"));
            }
        }
        return 1;
    }

    private static int removePlayerPermission(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        UUID playerUUID = player.getUUID();
        PermissionManager permissionManager = PermissionManager.getInstance();
        if (permissionManager.isPlayerAllowed(playerUUID)) {
            permissionManager.removePlayer(playerUUID);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Player " + player.getName().getString() + " foi removido da lista de permiss\u00f5es.")), true);
            permissionManager.savePermissions(((CommandSourceStack)context.getSource()).getServer());
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Player " + player.getName().getString() + " n\u00e3o est\u00e1 na lista de permiss\u00f5es.")));
        }
        return 1;
    }

    private static int setPlayerPermissionByPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        UUID playerUUID = player.getUUID();
        return PermissionCommand.setPlayerPermission(playerUUID, context);
    }

    private static int setPlayerPermissionByUUID(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        UUID playerUUID = UuidArgument.getUuid(context, (String)"UUID");
        return PermissionCommand.setPlayerPermission(playerUUID, context);
    }

    private static int setPlayerPermission(UUID playerUUID, CommandContext<CommandSourceStack> context) {
        PermissionManager permissionManager = PermissionManager.getInstance();
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(playerUUID);
        if (!permissionManager.isPlayerAllowed(playerUUID)) {
            permissionManager.addPlayer(playerUUID);
            PermissionCommand.listPermissions(context);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> PermissionCommand.lambda$setPlayerPermission$5((Player)player, playerUUID), true);
            permissionManager.savePermissions(((CommandSourceStack)context.getSource()).getServer());
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Player " + String.valueOf(player == null ? playerUUID : player.getName().getString()) + " j\u00e1 est\u00e1 na lista de permiss\u00f5es.")));
        return 1;
    }

    private static /* synthetic */ Component lambda$setPlayerPermission$5(Player player, UUID playerUUID) {
        return Component.literal((String)("Player " + String.valueOf(player == null ? playerUUID : player.getName().getString()) + " foi adicionado \u00e0 lista de permiss\u00f5es."));
    }
}

