/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.arkanisward;

import com.mojang.logging.LogUtils;
import com.pedrorok.arkanisward.command.PermissionCommand;
import com.pedrorok.arkanisward.command.SetAreaCommand;
import com.pedrorok.arkanisward.util.AreaManager;
import com.pedrorok.arkanisward.util.PermissionManager;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.slf4j.Logger;

@Mod(value="arkanisward")
public class ArkanisWard {
    public static final String MODID = "arkanisward";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final AreaManager areaManager = AreaManager.getInstance();

    public ArkanisWard(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        areaManager.loadAreas(event.getServer());
        PermissionManager.getInstance().loadPermissions(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        areaManager.saveAreas(event.getServer());
        PermissionManager.getInstance().savePermissions(event.getServer());
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        SetAreaCommand.registerCommands(event);
        PermissionCommand.registerCommands(event);
    }
}

