/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile.oit;

import dev.djefrey.colorwheel.Colorwheel;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import dev.engine_room.flywheel.backend.glsl.generate.FnSignature;
import dev.engine_room.flywheel.backend.glsl.generate.GlslBlock;
import dev.engine_room.flywheel.backend.glsl.generate.GlslBuilder;
import dev.engine_room.flywheel.backend.glsl.generate.GlslStmt;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OitCollectCoeffsComponent
implements SourceComponent {
    private final int[] ranks;
    private final Map<Integer, Integer> coeffFrag;
    private final Map<Integer, String> shaderOutputs;

    public OitCollectCoeffsComponent(int[] ranks, Map<Integer, Integer> coeffFrag, Map<Integer, String> shaderOutputs) {
        this.ranks = ranks;
        this.coeffFrag = coeffFrag;
        this.shaderOutputs = shaderOutputs;
    }

    public Collection<? extends SourceComponent> included() {
        return List.of();
    }

    public String source() {
        GlslBuilder builder = new GlslBuilder();
        GlslBlock body = new GlslBlock();
        body.add(GlslStmt.raw((String)"float linearDepth = _clrwl_linear_depth();"));
        body.add(GlslStmt.raw((String)"vec2 depthRange = texelFetch(_flw_depthRange, ivec2(gl_FragCoord.xy), 0).rg;"));
        body.add(GlslStmt.raw((String)"float delta = depthRange.x + depthRange.y;"));
        body.add(GlslStmt.raw((String)"float flw_depth = (linearDepth + depthRange.x) / delta;"));
        body.add(GlslStmt.raw((String)"float depth_adjustment = _clrwl_tented_blue_noise(flw_depth) * _flw_oitNoise;"));
        body.add(GlslStmt.raw((String)""));
        for (int i = 0; i < this.ranks.length; ++i) {
            int d;
            int rank = this.ranks[i];
            int frag = this.coeffFrag.get(i);
            int depth = 1 << rank - 1;
            String name = "clrwl_coeffs" + i;
            String fragData = this.shaderOutputs.get(frag);
            String transmittance = "transmittance" + i;
            String adjusted_depth = "adjusted_depth" + i;
            body.add(GlslStmt.raw((String)("float " + transmittance + " = 1.0 - " + fragData + ".a;")));
            body.add(GlslStmt.raw((String)("float " + adjusted_depth + " = flw_depth;")));
            body.add(GlslStmt.raw((String)("if (" + transmittance + " > 1e-5) { " + adjusted_depth + " -= depth_adjustment; } ")));
            body.add(GlslStmt.raw((String)("vec4[4] " + name + ";")));
            for (d = 0; d < depth; ++d) {
                body.add(GlslStmt.raw((String)(name + "[" + d + "] = vec4(0.);")));
            }
            body.add(GlslStmt.raw((String)("_clrwl_add_transmittance(" + name + ", " + transmittance + ", " + adjusted_depth + ", " + rank + ");")));
            for (d = 0; d < depth; ++d) {
                String outName = name + d;
                body.add(GlslStmt.raw((String)(outName + " = " + name + "[" + d + "];")));
            }
        }
        builder.function().signature(FnSignature.create().returnType("void").name("_clrwl_post_shader").build()).body(body);
        return builder.build();
    }

    public String name() {
        return Colorwheel.rl("oit_collect_coeffs").toString();
    }
}

